'use strict';

var grafanaPrometheus = {
	"grafana-prometheus": {
	components: {
		"annotation-query-editor": {
			"annotation-data-load-error": "Annotation data load error!",
			"aria-label-lower-limit-parameter": "Set lower limit for the step parameter",
			"label-min-step": "Min step",
			"label-series-value-as-timestamp": "Series value as timestamp",
			"label-tags": "Tags",
			"label-text": "Text",
			"label-title": "Title",
			"placeholder-auto": "auto",
			"tooltip-either-pattern-example-instance-replaced-label": "Use either the name or a pattern. For example, {{labelTemplate}} is replaced with label value for the label {{labelName}}.",
			"tooltip-min-step": "An additional lower limit for the step parameter of the Prometheus query and for the <2>{{intervalVar}}</2> and <4>{{rateIntervalVar}}</4> variables.",
			"tooltip-timestamp-milliseconds-series-value-seconds-multiply": "The unit of timestamp is milliseconds. If the unit of the series value is seconds, multiply its range vector by 1000."
		},
		"get-query-type-options": {
			description: {
				"instant-query-range": "Run an Instant query and a Range query"
			},
			label: {
				both: "Both"
			},
			"range-options": {
				description: {
					"query-range": "Run query over a range of time"
				},
				label: {
					instant: "Instant",
					range: "Range"
				}
			}
		},
		"label-selector": {
			"aria-label-filter-expression-for-label": "Filter expression for label",
			"description-select-labels": "Once label values are selected, only possible label combinations are shown.",
			"select-labels-to-search-in": "2. Select labels to search in"
		},
		"metric-selector": {
			"aria-label-filter-expression-for-metric": "Filter expression for metric",
			"aria-label-limit-results-from-series-endpoint": "Limit results from series endpoint",
			"description-series-limit": "The limit applies to all metrics, labels, and values. Leave the field empty to use the default limit. Set to 0 to disable the limit and fetch everything — this may cause performance issues.",
			"label-select-metric": "Once a metric is selected only possible labels are shown. Labels are limited by the series limit below.",
			"select-a-metric": "1. Select a metric",
			"series-limit": "Series limit"
		},
		"prom-cheat-sheet": {
			"prom-ql-cheat-sheet": "PromQL Cheat Sheet"
		},
		"prom-exemplar-field": {
			exemplars: "Exemplars",
			"tooltip-disable-query": "Disable query with exemplars",
			"tooltip-enable-query": "Enable query with exemplars"
		},
		"prom-explore-extra-field": {
			"aria-label-prometheus-extra-field": "Prometheus extra field",
			"aria-label-query-type-field": "Query type field",
			"aria-label-step-field": "Step field",
			"min-step": "Min step",
			"query-type": "Query type",
			"tooltip-units-builtin-variables-example-interval-rateinterval": "Time units and built-in variables can be used here, for example: {{example1}}, {{example2}}, {{example3}}, {{example4}}, {{example5}}, {{example6}}, {{example7}} (Default if no unit is specified: {{default}})"
		},
		"prom-query-field": {
			"placeholder-enter-a-prom-ql-query": "Enter a PromQL query…"
		},
		"prom-variable-query-editor": {
			"aria-label-classic-query": "Classic Query",
			"aria-label-metric-regex": "Metric regex",
			"aria-label-metric-selector": "Metric selector",
			"aria-label-prometheus-query": "Prometheus Query",
			"aria-label-query-type": "Query type",
			"aria-label-series-query": "Series Query",
			"label-classic-query": "Classic Query",
			"label-label": "Label",
			"label-metric-regex": "Metric regex",
			"label-query": "Query",
			"label-query-type": "Query type",
			"label-series-query": "Series Query",
			"placeholder-classic-query": "Classic Query",
			"placeholder-metric-regex": "Metric regex",
			"placeholder-prometheus-query": "Prometheus Query",
			"placeholder-select-query-type": "Select query type",
			"placeholder-series-query": "Series Query",
			"returns-metrics-matching-specified-metric-regex": "Returns a list of metrics matching the specified metric regex.",
			"tooltip-classic-query": "The original implementation of the Prometheus variable query editor. Enter a string with the correct query type and parameters as described in these docs. For example, {{exampleQuery}}.",
			"tooltip-label": "Returns a list of label values for the label name in all metrics unless the metric is specified.",
			"tooltip-metric-regex": "Returns a list of label names, optionally filtering by specified metric regex.",
			"tooltip-query": "Returns a list of Prometheus query results for the query. This can include Prometheus functions, i.e.{{exampleQuery}}.",
			"tooltip-query-type": "The Prometheus data source plugin provides the following query types for template variables.",
			"tooltip-series-query": "Enter a metric with labels, only a metric or only labels, i.e.{{example1}}, {{example2}}, or {{example3}}. Returns a list of time series associated with the entered data."
		},
		"selector-actions": {
			"aria-label-selector": "selector",
			"aria-label-selector-clear-button": "Selector clear button",
			"aria-label-use-selector-as-metrics-button": "Use selector as metrics button",
			"aria-label-use-selector-for-query-button": "Use selector for query button",
			"aria-label-validate-submit-button": "Validate submit button",
			clear: "Clear",
			"resulting-selector": "4. Resulting selector",
			"use-as-rate-query": "Use as rate query",
			"use-query": "Use query",
			"validate-selector": "Validate selector"
		},
		"value-selector": {
			"aria-label-filter-expression-for-label-values": "Filter expression for label values",
			"aria-label-values-for": "Values for {{labelKey}}",
			"description-search-field-values-across-selected-labels": "Use the search field to find values across selected labels.",
			"select-multiple-values-for-your-labels": "3. Select (multiple) values for your labels"
		}
	},
	configuration: {
		"alerting-settings-overhaul": {
			"label-allow-as-recording-rules-target": "Allow as recording rules target",
			"label-manage-alerts-via-alerting-ui": "Manage alerts via Alerting UI",
			"title-alerting": "Alerting",
			"tooltip-allow-as-recording-rules-target": "Allow this data source to be selected as a target for writing recording rules.",
			"tooltip-manage-alerts-via-alerting-ui": "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source."
		},
		"config-editor": {
			"browser-access-mode-error": "Browser access mode in the Prometheus data source is no longer available. Switch to server access mode.",
			"description-advanced-settings": "Additional settings are optional settings that can be configured for more control over your data source.",
			"title-advanced-settings": "Advanced settings",
			"title-error": "Error"
		},
		"data-source-http-settings-overhaul": {
			"tooltip-browser-access-mode": "Your access method is <1>Browser</1>, this means the URL needs to be accessible from the browser.",
			"tooltip-http-url": "Specify a complete HTTP URL (for example {{exampleURL}})",
			"tooltip-server-access-mode": "Your access method is <1>Server</1>, this means the URL needs to be accessible from the grafana backend/server."
		},
		"docs-tip": {
			"visit-docs-for-more-details-here": "Visit docs for more details here."
		},
		"exemplar-setting": {
			"label-data-source": "Data source",
			"label-internal-link": "Internal link",
			"label-label-name": "Label name",
			"label-remove-exemplar-link": "Remove exemplar link",
			"label-url": "URL",
			"label-url-label": "URL Label",
			"placeholder-go-to-examplecom": "Go to example.com",
			"placeholder-httpsexamplecomvalueraw": "https://example.com/${__value.raw}",
			"placeholder-trace-id": "traceID",
			"title-remove-exemplar-link": "Remove exemplar link",
			"tooltip-data-source": "The data source the exemplar is going to navigate to.",
			"tooltip-internal-link": "Enable this option if you have an internal link. When enabled, this reveals the data source selector. Select the backend tracing data store for your exemplar data.",
			"tooltip-label-name": "The name of the field in the labels object that should be used to get the traceID.",
			"tooltip-url": "The URL of the trace backend the user would go to see its trace",
			"tooltip-url-label": "Use to override the button label on the exemplar traceID field."
		},
		"exemplars-settings": {
			add: "Add",
			"no-exemplars-configurations": "No exemplars configurations",
			"title-exemplars": "Exemplars"
		},
		"prom-settings": {
			"aria-label-default-editor": "Default Editor (Code or Builder)",
			"aria-label-prom-type-type": "{{promType}} type",
			"aria-label-prometheus-type": "Prometheus type",
			"aria-label-select-http-method": "Select HTTP method",
			"editor-options": {
				"label-builder": "Builder",
				"label-code": "Code"
			},
			"label-cache-level": "Cache level",
			"label-custom-query-parameters": "Custom query parameters",
			"label-default-editor": "Default editor",
			"label-disable-metrics-lookup": "Disable metrics lookup",
			"label-disable-recording-rules-beta": "Disable recording rules (beta)",
			"label-http-method": "HTTP method",
			"label-incremental-querying-beta": "Incremental querying (beta)",
			"label-metric-names-suggestion-limit": "Metric names suggestion limit",
			"label-prom-type-version": "{{promType}} version",
			"label-prometheus-type": "Prometheus type",
			"label-query-overlap-window": "Query overlap window",
			"label-query-timeout": "Query timeout",
			"label-scrape-interval": "Scrape interval",
			"label-series-limit": "Series limit",
			"label-use-series-endpoint": "Use series endpoint",
			"more-info": "For more information on configuring prometheus type and version in data sources, see the <2>provisioning documentation</2>.",
			"placeholder-example-maxsourceresolutionmtimeout": "Example: {{example}}",
			"title-interval-behaviour": "Interval behaviour",
			"title-other": "Other",
			"title-performance": "Performance",
			"title-query-editor": "Query editor",
			"tooltip-cache-level": "Sets the browser caching level for editor queries. Higher cache settings are recommended for high cardinality data sources.",
			"tooltip-custom-query-parameters": "Add custom parameters to the Prometheus query URL. For example {{example1}}, {{example2}}, {{example3}}, or{{example4}}. Multiple parameters should be concatenated together with {{concatenationChar}}.",
			"tooltip-default-editor": "Set default editor option for all users of this data source.",
			"tooltip-disable-metrics-lookup": "Checking this option will disable the metrics chooser and metric/label support in the query field's autocomplete. This helps if you have performance issues with bigger Prometheus instances. ",
			"tooltip-disable-recording-rules-beta": "This feature will disable recording rules. Turn this on to improve dashboard performance",
			"tooltip-http-method": "You can use either POST or GET HTTP method to query your Prometheus data source. POST is the recommended method as it allows bigger queries. Change this to GET if you have a Prometheus version older than 2.1 or if POST requests are restricted in your network.",
			"tooltip-incremental-querying-beta": "This feature will change the default behavior of relative queries to always request fresh data from the prometheus instance, instead query results will be cached, and only new records are requested. Turn this on to decrease database and network load.",
			"tooltip-metric-names-suggestion-limit": "The maximum number of metric names that may appear as autocomplete suggestions in the query editor's Code mode.",
			"tooltip-prom-type-version": "Use this to set the version of your {{promType}} instance if it is not automatically configured.",
			"tooltip-prometheus-type": "Set this to the type of your prometheus database, e.g. Prometheus, Cortex, Mimir or Thanos. Changing this field will save your current settings. Certain types of Prometheus supports or does not support various APIs. For example, some types support regex matching for label queries to improve performance. Some types have an API for metadata. If you set this incorrectly you may experience odd behavior when querying metrics and labels. Please check your Prometheus documentation to ensure you enter the correct type.",
			"tooltip-query-overlap-window": "Set a duration like {{example1}} or {{example2}} or {{example3}}. Default of {{default}}. This duration will be added to the duration of each incremental request.",
			"tooltip-query-timeout": "Set the Prometheus query timeout.",
			"tooltip-scrape-interval": "This interval is how frequently Prometheus scrapes targets. Set this to the typical scrape and evaluation interval configured in your Prometheus config file. If you set this to a greater value than your Prometheus config file interval, Grafana will evaluate the data according to this interval and you will see less data points. Defaults to {{default}}.",
			"tooltip-series-limit": "The limit applies to all resources (metrics, labels, and values) for both endpoints (series and labels). Leave the field empty to use the default limit (40000). Set to 0 to disable the limit and fetch everything — this may cause performance issues. Default limit is 40000.",
			"tooltip-use-series-endpoint": "Checking this option will favor the series endpoint with {{exampleParameter}} parameter over the label values endpoint with {{exampleParameter}} parameter. While the label values endpoint is considered more performant, some users may prefer the series because it has a POST method while the label values endpoint only has a GET method."
		}
	},
	"prom-query-legend-editor": {
		"get-legend-mode-options": {
			"description-auto": "Only includes unique labels",
			"description-custom": "Provide a naming template",
			"description-verbose": "All label names and values",
			"label-auto": "Auto",
			"label-custom": "Custom",
			"label-verbose": "Verbose"
		}
	},
	querybuilder: {
		"additional-settings": {
			"content-filter-metric-names-regex-search-using": "Filter metric names by regex search, using an additional call on the Prometheus API.",
			"disable-text-wrap": "Disable text wrap"
		},
		"feedback-link": {
			"give-feedback": "Give feedback",
			"title-give-feedback": "The metrics explorer is new, please let us know how we can improve it"
		},
		"get-collapsed-info": {
			exemplars: "Exemplars: {{value}}",
			format: "Format: {{value}}",
			legend: "Legend: {{value}}",
			step: "Step: {{value}}",
			type: "Type: {{value}}"
		},
		"handle-function": {
			text: {
				"query-parsing-is-ambiguous": "Query parsing is ambiguous."
			}
		},
		"label-filter-item": {
			"aria-label-remove": "Remove {{name}}",
			"placeholder-select-label": "Select label",
			"placeholder-select-value": "Select value"
		},
		"label-filters": {
			"label-filters": "Label filters",
			"label-label-filters": "Label filters",
			"tooltip-label-filters": "Optional: used to filter the metric select for this query type."
		},
		"label-param-editor": {
			"loadingMessage-loading-labels": "Loading labels",
			"noOptionsMessage-no-labels-found": "No labels found"
		},
		"metric-combobox": {
			"async-select": {
				"aria-label-open-metrics-explorer": "Open metrics explorer",
				"placeholder-select-metric": "Select metric",
				"tooltip-open-metrics-explorer": "Open metrics explorer"
			},
			"label-metric": "Metric",
			"tooltip-metric": "Optional: returns a list of label values for the label name in the specified metric."
		},
		"metrics-modal": {
			"additional-settings": "Additional Settings",
			"aria-label-additional-settings": "Additional settings",
			"aria-label-browse-metrics": "Browse metrics",
			"currently-selected": "Currently selected: {{selected}}",
			"metrics-pre-filtered": "These metrics have been pre-filtered by labels chosen in the label filters.",
			"placeholder-results-per-page": "results per page",
			"results-amount_one": "Showing {{num}} of {{count}} results",
			"results-amount_other": "Showing {{num}} of {{count}} results",
			"results-per-page": "Results per page",
			"title-metrics-explorer": "Metrics explorer"
		},
		"nested-query": {
			label: {
				ignoring: "Ignoring",
				on: "On"
			},
			operator: "Operator",
			"tooltip-remove-match": "Remove match",
			"vector-matches": "Vector matches"
		},
		"operation-editor": {
			"not-found": "Operation {{id}} not found",
			"title-remove": "Remove {{name}}"
		},
		"operation-header": {
			"placeholder-replace-with": "Replace with",
			"title-click-to-view-alternative-operations": "Click to view alternative operations",
			"title-remove-operation": "Remove operation"
		},
		"operation-info-button": {
			"title-click-to-show-description": "Click to show description",
			"title-remove-operation": "Remove operation"
		},
		"operation-list": {
			operations: "Operations",
			"placeholder-search": "Search",
			"title-add-operation": "Add operation"
		},
		"operation-param-editor": {
			"title-add": "Add {{name}}",
			"title-remove": "Remove {{name}}"
		},
		"prom-query-builder-options": {
			"aria-label-lower-limit-parameter": "Set lower limit for the step parameter",
			"aria-label-select-resolution": "Select resolution",
			"format-options": {
				"label-heatmap": "Heatmap",
				"label-table": "Table",
				"label-time-series": "Time series"
			},
			"label-exemplars": "Exemplars",
			"label-format": "Format",
			"label-min-step": "Min step",
			"label-resolution": "Resolution",
			"label-type": "Type",
			"placeholder-auto": "auto",
			"title-options": "Options",
			"tooltip-min-step": "An additional lower limit for the step parameter of the Prometheus query and for the <2>{{interval}}</2> and <4>{{rateInterval}}</4> variables."
		},
		"prom-query-code-editor-autocomplete-info": {
			"autocomplete-suggestions-limited": "Autocomplete suggestions limited",
			"tooltip-autocomplete-suggestions-limited": "The number of metric names exceeds the autocomplete limit. Only the {{autocompleteLimit}}-most relevant metrics are displayed. You can adjust the threshold in the data source settings."
		},
		"prom-query-editor-selector": {
			"body-syntax-error": "There is a syntax error, or the query structure cannot be visualized when switching to the builder mode. Parts of the query may be lost.",
			"confirmText-continue": "Continue",
			"kick-start-your-query": "Kick start your query",
			"label-explain": "Explain",
			"run-queries": "Run queries",
			"title-parsing-error-switch-builder": "Parsing error: Switch to the builder mode?"
		},
		"prom-query-legend-editor": {
			"label-legend": "Legend",
			"placeholder-select-legend-mode": "Select legend mode",
			"tooltip-legend": "Series name override or template. Ex. {{templateExample}} will be replaced with label value for {{labelName}}."
		},
		"query-builder-hints": {
			"hint-details": "hint: {{hintDetails}}"
		},
		"query-editor-hints": {
			"hint-details": "hint: {{hintDetails}}"
		},
		"query-editor-mode-toggle": {
			"editor-modes": {
				"label-builder": "Builder",
				"label-code": "Code"
			}
		},
		"query-pattern": {
			"apply-query": "Apply query",
			"aria-label-apply-query-starter-button": "apply query starter button",
			"aria-label-back-button": "back button",
			"aria-label-create-new-query-button": "create new query button",
			"aria-label-raw-query": "{{patternName}} raw query",
			"aria-label-use-this-query-button": "use this query button",
			back: "Back",
			"create-new-query": "Create new query",
			"use-this-query": "Use this query"
		},
		"query-patterns-modal": {
			"aria-label-close-kick-start-your-query-modal": "close kick start your query modal",
			"aria-label-kick-start-your-query-modal": "Kick start your query modal",
			"aria-label-toggle-query-starter": "open and close {{patternType}} query starter card",
			close: "Close",
			"description-kick-start-your-query": "Kick start your query by selecting one of these queries. You can then continue to complete your query.",
			"label-toggle-query-starter": "{{patternType}} query starters",
			"title-kick-start-your-query": "Kick start your query"
		},
		"raw-query": {
			"aria-label-selector": "selector"
		},
		"results-table": {
			"content-descriptive-type": "When creating a {{descriptiveType}}, Prometheus exposes multiple series with the type counter. ",
			description: "Description",
			name: "Name",
			select: "Select",
			type: "Type"
		},
		"update-function-args": {
			text: {
				"query-parsing-is-ambiguous": "Query parsing is ambiguous."
			}
		}
	}
}
};

exports.default = grafanaPrometheus;
//# sourceMappingURL=grafana-prometheus-B8UdHyaQ.js.map
