import { jsx, Fragment } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { getFocusStyles } from '../../themes/mixins.mjs';

"use strict";
const CardInner = ({ children, href }) => {
  const { inner } = useStyles2(getCardInnerStyles);
  return href ? /* @__PURE__ */ jsx("a", { className: inner, href, children }) : /* @__PURE__ */ jsx(Fragment, { children });
};
const getCardInnerStyles = (theme) => ({
  inner: css({
    display: "flex",
    width: "100%",
    padding: theme.spacing(2)
  })
});
const CardContainer = ({
  children,
  disableEvents,
  disableHover,
  isSelected,
  className,
  href,
  noMargin,
  ...props
}) => {
  const { oldContainer } = useStyles2(
    getCardContainerStyles,
    disableEvents,
    disableHover,
    isSelected,
    void 0,
    noMargin
  );
  return /* @__PURE__ */ jsx("div", { ...props, className: cx(oldContainer, className), children: /* @__PURE__ */ jsx(CardInner, { href, children }) });
};
const getCardContainerStyles = (theme, disabled = false, disableHover = false, isSelected, isCompact, noMargin = false) => {
  const isSelectable = isSelected !== void 0;
  return {
    container: css({
      display: "grid",
      position: "relative",
      gridTemplateColumns: "auto 1fr auto",
      gridTemplateRows: "1fr auto auto auto",
      gridAutoColumns: "1fr",
      gridAutoFlow: "row",
      gridTemplateAreas: `
        "Figure Heading Tags"
        "Figure Meta Tags"
        "Figure Description Tags"
        "Figure Actions Secondary"`,
      width: "100%",
      padding: theme.spacing(isCompact ? 1 : 2),
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(noMargin ? 0 : 1),
      pointerEvents: disabled ? "none" : "auto",
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
          duration: theme.transitions.duration.short
        })
      },
      ...!disableHover && {
        "&:hover": {
          background: theme.colors.emphasize(theme.colors.background.secondary, 0.03),
          cursor: "pointer",
          zIndex: 1
        },
        "&:focus": getFocusStyles(theme)
      },
      ...isSelectable && {
        cursor: "pointer"
      },
      ...isSelected && {
        outline: `solid 2px ${theme.colors.primary.border}`
      }
    }),
    oldContainer: css({
      display: "flex",
      width: "100%",
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      position: "relative",
      pointerEvents: disabled ? "none" : "auto",
      marginBottom: theme.spacing(noMargin ? 0 : 1),
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
          duration: theme.transitions.duration.short
        })
      },
      ...!disableHover && {
        "&:hover": {
          background: theme.colors.emphasize(theme.colors.background.secondary, 0.03),
          cursor: "pointer",
          zIndex: 1
        },
        "&:focus": getFocusStyles(theme)
      }
    })
  };
};

export { CardContainer, getCardContainerStyles };
//# sourceMappingURL=CardContainer.mjs.map
