import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { uniqueId } from 'lodash';
import { PureComponent } from 'react';
import { withTheme2 } from '../../../../themes/ThemeContext.mjs';
import { Icon } from '../../../Icon/Icon.mjs';
import { Tooltip } from '../../../Tooltip/Tooltip.mjs';

"use strict";
class UnthemedSwitch extends PureComponent {
  constructor() {
    super(...arguments);
    this.state = {
      id: uniqueId()
    };
    this.internalOnChange = (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    };
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      theme,
      tooltip,
      tooltipPlacement
    } = this.props;
    const styles = getStyles(theme);
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = cx(styles.switch, switchClass, {
      [styles.switchTransparent]: transparent
    });
    return /* @__PURE__ */ jsx("div", { className: styles.container, children: /* @__PURE__ */ jsxs("label", { htmlFor: labelId, className: cx("gf-form", styles.labelContainer, className), children: [
      label && /* @__PURE__ */ jsxs("div", { className: labelClassName, children: [
        label,
        tooltip && /* @__PURE__ */ jsx(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info", children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }) })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: switchClassName, children: [
        /* @__PURE__ */ jsx(
          "input",
          {
            disabled,
            id: labelId,
            type: "checkbox",
            checked,
            onChange: this.internalOnChange
          }
        ),
        /* @__PURE__ */ jsx("span", { className: styles.slider })
      ] })
    ] }) });
  }
}
const Switch = withTheme2(UnthemedSwitch);
const getStyles = (theme) => {
  const slider = css({
    background: theme.v1.palette.gray1,
    borderRadius: theme.shape.radius.pill,
    height: "16px",
    width: "32px",
    display: "block",
    position: "relative",
    "&::before": {
      position: "absolute",
      content: "''",
      height: "12px",
      width: "12px",
      left: "2px",
      top: "2px",
      background: theme.components.input.background,
      transition: "0.4s",
      borderRadius: theme.shape.radius.circle,
      boxShadow: theme.shadows.z1
    }
  });
  return {
    container: css({
      display: "flex",
      flexShrink: 0
    }),
    labelContainer: css({
      display: "flex",
      cursor: "pointer",
      marginRight: theme.spacing(0.5)
    }),
    switch: css({
      display: "flex",
      position: "relative",
      width: "56px",
      height: theme.spacing(4),
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      alignItems: "center",
      justifyContent: "center",
      input: {
        opacity: 0,
        width: 0,
        height: 0
      },
      [`input:checked + .${slider}`]: {
        background: theme.colors.primary.main
      },
      [`input:checked + .${slider}::before`]: {
        transform: "translateX(16px)"
      }
    }),
    switchTransparent: css({
      background: "transparent",
      border: 0,
      width: "40px"
    }),
    slider
  };
};

export { Switch };
//# sourceMappingURL=Switch.mjs.map
