"use strict";
var ActionType = /* @__PURE__ */ ((ActionType2) => {
  ActionType2["Fetch"] = "fetch";
  return ActionType2;
})(ActionType || {});
var ActionVariableType = /* @__PURE__ */ ((ActionVariableType2) => {
  ActionVariableType2["String"] = "string";
  return ActionVariableType2;
})(ActionVariableType || {});
var HttpRequestMethod = /* @__PURE__ */ ((HttpRequestMethod2) => {
  HttpRequestMethod2["POST"] = "POST";
  HttpRequestMethod2["PUT"] = "PUT";
  HttpRequestMethod2["GET"] = "GET";
  return HttpRequestMethod2;
})(HttpRequestMethod || {});
const httpMethodOptions = [
  { label: "POST" /* POST */, value: "POST" /* POST */ },
  { label: "PUT" /* PUT */, value: "PUT" /* PUT */ },
  { label: "GET" /* GET */, value: "GET" /* GET */ }
];
const contentTypeOptions = [
  { label: "application/json", value: "application/json" },
  { label: "text/plain", value: "text/plain" },
  { label: "application/xml", value: "application/xml" },
  { label: "application/x-www-form-urlencoded", value: "application/x-www-form-urlencoded" }
];
const defaultActionConfig = {
  type: "fetch" /* Fetch */,
  title: "",
  fetch: {
    url: "",
    method: "POST" /* POST */,
    body: "{}",
    queryParams: [],
    headers: [["Content-Type", "application/json"]]
  }
};

export { ActionType, ActionVariableType, HttpRequestMethod, contentTypeOptions, defaultActionConfig, httpMethodOptions };
//# sourceMappingURL=action.mjs.map
