import { DataSourceApi, PluginType } from '@grafana/data';

"use strict";
class RuntimeDataSource extends DataSourceApi {
  constructor(pluginId, uid) {
    const instanceSettings = {
      name: "RuntimeDataSource-" + pluginId,
      uid,
      type: pluginId,
      id: 1,
      readOnly: true,
      jsonData: {},
      access: "direct",
      meta: {
        id: pluginId,
        name: "RuntimeDataSource-" + pluginId,
        type: PluginType.datasource,
        info: {
          author: {
            name: ""
          },
          description: "",
          links: [],
          logos: {
            large: "",
            small: ""
          },
          screenshots: [],
          updated: "",
          version: ""
        },
        module: "",
        baseUrl: ""
      }
    };
    super(instanceSettings);
    this.instanceSettings = instanceSettings;
  }
  testDatasource() {
    return Promise.resolve({
      status: "success",
      message: ""
    });
  }
}

export { RuntimeDataSource };
//# sourceMappingURL=RuntimeDataSource.mjs.map
