import { TimeRange } from '@grafana/data';
import { BackendSrvRequest } from '@grafana/runtime';
import { PrometheusDatasource } from './datasource';
type PrometheusSeriesResponse = Array<{
    [key: string]: string;
}>;
type PrometheusLabelsResponse = string[];
export interface ResourceApiClient {
    metrics: string[];
    histogramMetrics: string[];
    labelKeys: string[];
    cachedLabelValues: Record<string, string[]>;
    start: (timeRange: TimeRange) => Promise<void>;
    queryMetrics: (timeRange: TimeRange) => Promise<{
        metrics: string[];
        histogramMetrics: string[];
    }>;
    queryLabelKeys: (timeRange: TimeRange, match?: string, limit?: number) => Promise<string[]>;
    queryLabelValues: (timeRange: TimeRange, labelKey: string, match?: string, limit?: number) => Promise<string[]>;
    querySeries: (timeRange: TimeRange, match: string, limit: number) => Promise<PrometheusSeriesResponse>;
}
type RequestFn = (url: string, params?: Record<string, unknown>, options?: Partial<BackendSrvRequest>) => Promise<unknown>;
export declare abstract class BaseResourceClient {
    protected readonly request: RequestFn;
    protected readonly datasource: PrometheusDatasource;
    private seriesLimit;
    constructor(request: RequestFn, datasource: PrometheusDatasource);
    protected getEffectiveLimit(limit?: number): number;
    protected requestLabels(url: string, params?: Record<string, unknown>, options?: Partial<BackendSrvRequest>): Promise<PrometheusLabelsResponse>;
    protected requestSeries(url: string, params?: Record<string, unknown>, options?: Partial<BackendSrvRequest>): Promise<PrometheusSeriesResponse>;
    /**
     * Fetches all time series that match a specific label matcher using **series** endpoint.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} match - Label matcher to filter time series
     * @param {string} limit - Maximum number of series to return
     */
    querySeries: (timeRange: TimeRange, match: string | undefined, limit: number) => Promise<PrometheusSeriesResponse>;
}
export declare class LabelsApiClient extends BaseResourceClient implements ResourceApiClient {
    private _cache;
    histogramMetrics: string[];
    metrics: string[];
    labelKeys: string[];
    cachedLabelValues: Record<string, string[]>;
    start: (timeRange: TimeRange) => Promise<void>;
    queryMetrics: (timeRange: TimeRange) => Promise<{
        metrics: string[];
        histogramMetrics: string[];
    }>;
    /**
     * Fetches all available label keys from Prometheus using labels endpoint.
     * Uses the labels endpoint with optional match parameter for filtering.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} match - Optional label matcher to filter results
     * @param {string} limit - Maximum number of results to return
     * @returns {Promise<string[]>} Array of label keys sorted alphabetically
     */
    queryLabelKeys: (timeRange: TimeRange, match?: string, limit?: number) => Promise<string[]>;
    /**
     * Fetches all values for a specific label key from Prometheus using labels values endpoint.
     *
     * @param {TimeRange} timeRange - Time range to use for the query
     * @param {string} labelKey - The label key to fetch values for
     * @param {string} match - Optional label matcher to filter results
     * @param {string} limit - Maximum number of results to return
     * @returns {Promise<string[]>} Array of label values
     */
    queryLabelValues: (timeRange: TimeRange, labelKey: string, match?: string, limit?: number) => Promise<string[]>;
}
export declare class SeriesApiClient extends BaseResourceClient implements ResourceApiClient {
    private _cache;
    histogramMetrics: string[];
    metrics: string[];
    labelKeys: string[];
    cachedLabelValues: Record<string, string[]>;
    start: (timeRange: TimeRange) => Promise<void>;
    queryMetrics: (timeRange: TimeRange) => Promise<{
        metrics: string[];
        histogramMetrics: string[];
    }>;
    queryLabelKeys: (timeRange: TimeRange, match?: string, limit?: number) => Promise<string[]>;
    queryLabelValues: (timeRange: TimeRange, labelKey: string, match?: string, limit?: number) => Promise<string[]>;
}
export declare function processSeries(series: Array<{
    [key: string]: string;
}>, findValuesForKey?: string): {
    metrics: string[];
    labelKeys: string[];
    labelValues: string[];
};
export {};
