import { PromVisualQueryOperationCategory } from '../../types.mjs';

"use strict";
function renderOperations(queryString, operations, operationsRegistry) {
  for (const operation of operations) {
    const def = operationsRegistry.get(operation.id);
    if (!def) {
      throw new Error(`Could not find operation ${operation.id} in the registry`);
    }
    queryString = def.renderer(operation, def, queryString);
  }
  return queryString;
}
function hasBinaryOp(query, operationsRegistry) {
  return query.operations.find((op) => {
    const def = operationsRegistry.get(op.id);
    return (def == null ? void 0 : def.category) === PromVisualQueryOperationCategory.BinaryOps;
  }) !== void 0;
}

export { hasBinaryOp, renderOperations };
//# sourceMappingURL=operations.mjs.map
