import { DataGridProps, SortColumn } from 'react-data-grid';
import { Field, LinkModel } from '@grafana/data';
import { TableColumnResizeActionCallback } from '../types';
import { FilterType, TableFooterCalc, TableRow, TableSortByFieldState, TableSummaryRow } from './types';
export interface FilteredRowsResult {
    rows: TableRow[];
    filter: FilterType;
    setFilter: React.Dispatch<React.SetStateAction<FilterType>>;
    crossFilterOrder: string[];
    crossFilterRows: Record<string, TableRow[]>;
}
export interface FilteredRowsOptions {
    hasNestedFrames: boolean;
}
export declare function useFilteredRows(rows: TableRow[], fields: Field[], { hasNestedFrames }: FilteredRowsOptions): FilteredRowsResult;
export interface SortedRowsOptions {
    hasNestedFrames: boolean;
    initialSortBy?: TableSortByFieldState[];
}
export interface SortedRowsResult {
    rows: TableRow[];
    sortColumns: SortColumn[];
    setSortColumns: React.Dispatch<React.SetStateAction<SortColumn[]>>;
}
export declare function useSortedRows(rows: TableRow[], fields: Field[], { initialSortBy, hasNestedFrames }: SortedRowsOptions): SortedRowsResult;
export interface PaginatedRowsOptions {
    height: number;
    width: number;
    rowHeight: number | ((row: TableRow) => number);
    headerHeight: number;
    footerHeight: number;
    paginationHeight?: number;
    enabled: boolean;
}
export interface PaginatedRowsResult {
    rows: TableRow[];
    page: number;
    setPage: React.Dispatch<React.SetStateAction<number>>;
    numPages: number;
    rowsPerPage: number;
    pageRangeStart: number;
    pageRangeEnd: number;
    smallPagination: boolean;
}
export declare function usePaginatedRows(rows: TableRow[], { height, width, headerHeight, footerHeight, rowHeight, enabled }: PaginatedRowsOptions): PaginatedRowsResult;
export interface FooterCalcsOptions {
    enabled?: boolean;
    isCountRowsSet?: boolean;
    footerOptions?: TableFooterCalc;
}
export declare function useFooterCalcs(rows: TableRow[], fields: Field[], { enabled, footerOptions, isCountRowsSet }: FooterCalcsOptions): string[];
interface TypographyCtx {
    ctx: CanvasRenderingContext2D;
    font: string;
    avgCharWidth: number;
    calcRowHeight: (text: string, cellWidth: number, defaultHeight: number) => number;
}
export declare function useTypographyCtx(): TypographyCtx;
interface UseHeaderHeightOptions {
    enabled: boolean;
    fields: Field[];
    columnWidths: number[];
    defaultHeight: number;
    sortColumns: SortColumn[];
    typographyCtx: TypographyCtx;
    showTypeIcons?: boolean;
}
export declare function useHeaderHeight({ fields, enabled, columnWidths, defaultHeight, sortColumns, typographyCtx: { calcRowHeight, avgCharWidth }, showTypeIcons, }: UseHeaderHeightOptions): number;
interface UseRowHeightOptions {
    columnWidths: number[];
    fields: Field[];
    hasNestedFrames: boolean;
    defaultHeight: number;
    headerHeight: number;
    expandedRows: Record<string, boolean>;
    typographyCtx: TypographyCtx;
}
export declare function useRowHeight({ columnWidths, fields, hasNestedFrames, defaultHeight, headerHeight, expandedRows, typographyCtx: { calcRowHeight, avgCharWidth }, }: UseRowHeightOptions): number | ((row: TableRow) => number);
export declare function useColumnResize(onColumnResize?: TableColumnResizeActionCallback): DataGridProps<TableRow, TableSummaryRow>['onColumnResize'];
export declare function useSingleLink(field: Field, rowIdx: number): LinkModel | undefined;
export {};
