import { ContactPoint } from '../api/v0alpha1/types';
/**
 * Generates a human-readable description of a ContactPoint by summarizing its integrations.
 * If the ContactPoint has no integrations, it returns an empty placeholder text.
 *
 * For integrations, it counts the occurrences of each type and formats them as a comma-separated list.
 * Multiple integrations of the same type are indicated with a count in parentheses.
 *
 * @param contactPoint - The ContactPoint object to describe
 * @returns A string description of the ContactPoint's integrations
 */
export declare function getContactPointDescription(contactPoint: ContactPoint): string;
