import * as React from 'react';
import { ButtonVariant } from '../Button/Button';
import { JustifyContent } from '../Layout/types';
import { ResponsiveProp } from '../Layout/utils/responsiveness';
export interface ConfirmContentProps {
    /** Modal content */
    body: React.ReactNode;
    /** Modal description */
    description?: React.ReactNode;
    /** Text for confirm button */
    confirmButtonLabel: string;
    /** Confirm button variant */
    confirmButtonVariant?: ButtonVariant;
    /** Text user needs to fill in before confirming */
    confirmPromptText?: string;
    /** Text for dismiss button */
    dismissButtonLabel?: string;
    /** Variant for dismiss button */
    dismissButtonVariant?: ButtonVariant;
    /** Text for alternative button */
    alternativeButtonLabel?: string;
    /** Justify for buttons placement */
    justifyButtons?: ResponsiveProp<JustifyContent>;
    /** Confirm action callback
     * Return a promise to disable the confirm button until the promise is resolved
     */
    onConfirm(): void | Promise<void>;
    /** Dismiss action callback */
    onDismiss(): void;
    /** Alternative action callback */
    onAlternative?(): void;
    /** Disable the confirm button and the confirm text input if needed */
    disabled?: boolean;
}
export declare const ConfirmContent: ({ body, confirmPromptText, confirmButtonLabel, confirmButtonVariant, dismissButtonVariant, dismissButtonLabel, onConfirm, onDismiss, onAlternative, alternativeButtonLabel, description, justifyButtons, disabled, }: ConfirmContentProps) => import("react/jsx-runtime").JSX.Element;
