import { jsx } from 'react/jsx-runtime';
import { cx, keyframes, css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

"use strict";
const LoadingIndicator = ({ onCancel, loading }) => {
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;
  const styles = useStyles2(getStyles);
  if (!loading) {
    return null;
  }
  return /* @__PURE__ */ jsx(Tooltip, { content: t("grafana-ui.panel-chrome.tooltip-cancel-loading", "Cancel query"), children: /* @__PURE__ */ jsx(
    Icon,
    {
      className: cx(styles.spin, { [styles.clickable]: !!onCancel }),
      name: prefersReducedMotion ? "hourglass" : "sync",
      size: "sm",
      onClick: onCancel,
      "data-testid": selectors.components.LoadingIndicator.icon
    }
  ) });
};
const spin = keyframes({
  "0%": {
    transform: "rotate(0deg) scaleX(-1)"
    // scaleX flips the `sync` icon so arrows point the correct way
  },
  "100%": {
    transform: "rotate(359deg) scaleX(-1)"
  }
});
const getStyles = (theme) => {
  return {
    clickable: css({
      cursor: "pointer"
    }),
    spin: css({
      [theme.transitions.handleMotion("no-preference")]: {
        animation: `${spin} 3s linear infinite`
      }
    })
  };
};

export { LoadingIndicator };
//# sourceMappingURL=LoadingIndicator.mjs.map
