import { DataFrame, DataQueryRequest, DataQueryResponse } from '@grafana/data';
import { ExemplarTraceIdDestination, PromQuery } from './types';
export declare function transformV2(response: DataQueryResponse, request: DataQueryRequest<PromQuery>, options: {
    exemplarTraceIdDestinations?: ExemplarTraceIdDestination[];
}): {
    data: DataFrame[];
    key?: string;
    error?: import("@grafana/data").DataQueryError;
    errors?: import("@grafana/data").DataQueryError[];
    state?: import("@grafana/data").LoadingState;
    traceIds?: string[];
};
export declare function transformDFToTable(dfs: DataFrame[]): DataFrame[];
export declare function getOriginalMetricName(labelData: {
    [key: string]: string;
}): string;
/** @internal */
export declare function transformToHistogramOverTime(seriesList: DataFrame[]): DataFrame[];
export declare function sortSeriesByLabel(s1: DataFrame, s2: DataFrame): number;
/** @internal */
export declare function parseSampleValue(value: string): number;
