import { jsxs, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { FixedSizeList } from 'react-window';
import { selectors } from '@grafana/e2e-selectors';
import { t, Trans } from '@grafana/i18n';
import { useStyles2, Label, Input, BrowserLabel } from '@grafana/ui';
import { LIST_ITEM_SIZE } from '../../constants.mjs';
import { useMetricsBrowser } from './MetricsBrowserContext.mjs';
import { getStylesValueSelector } from './styles.mjs';

"use strict";
function ValueSelector() {
  const styles = useStyles2(getStylesValueSelector);
  const [valueSearchTerm, setValueSearchTerm] = useState("");
  const { labelValues, selectedLabelValues, onLabelValueClick, onLabelKeyClick } = useMetricsBrowser();
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(
      Label,
      {
        description: t(
          "grafana-prometheus.components.value-selector.description-search-field-values-across-selected-labels",
          "Use the search field to find values across selected labels."
        ),
        children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.value-selector.select-multiple-values-for-your-labels", children: "3. Select (multiple) values for your labels" })
      }
    ),
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(
      Input,
      {
        onChange: (e) => setValueSearchTerm(e.currentTarget.value),
        "aria-label": t(
          "grafana-prometheus.components.value-selector.aria-label-filter-expression-for-label-values",
          "Filter expression for label values"
        ),
        value: valueSearchTerm,
        "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.labelValuesFilter
      }
    ) }),
    /* @__PURE__ */ jsx("div", { className: styles.valueListArea, children: Object.entries(labelValues).map(([lk, lv]) => {
      if (!lk || !lv) {
        console.error("label values are empty:", { lk, lv });
        return null;
      }
      return /* @__PURE__ */ jsxs(
        "div",
        {
          role: "list",
          "aria-label": t(
            "grafana-prometheus.components.value-selector.aria-label-values-for",
            "Values for {{labelKey}}",
            {
              labelKey: lk
            }
          ),
          className: styles.valueListWrapper,
          children: [
            /* @__PURE__ */ jsx("div", { className: styles.valueTitle, children: /* @__PURE__ */ jsx(
              BrowserLabel,
              {
                name: lk,
                loading: false,
                active: true,
                hidden: false,
                facets: lv.length,
                onClick: onLabelKeyClick
              }
            ) }),
            /* @__PURE__ */ jsx(
              FixedSizeList,
              {
                height: Math.min(200, LIST_ITEM_SIZE * (lv.length || 0)),
                itemCount: lv.length || 0,
                itemSize: 28,
                itemKey: (i) => lv[i],
                width: 200,
                className: styles.valueList,
                children: ({ index, style }) => {
                  var _a;
                  const value = lv[index];
                  const isSelected = (_a = selectedLabelValues[lk]) == null ? void 0 : _a.includes(value);
                  return /* @__PURE__ */ jsx("div", { style, children: /* @__PURE__ */ jsx(
                    BrowserLabel,
                    {
                      name: value,
                      value,
                      active: isSelected,
                      onClick: (name) => onLabelValueClick(lk, name, !isSelected),
                      searchTerm: valueSearchTerm
                    }
                  ) });
                }
              }
            )
          ]
        },
        lk
      );
    }) })
  ] });
}

export { ValueSelector };
//# sourceMappingURL=ValueSelector.mjs.map
