import { ComboboxOption } from './types';
type AsyncOptions<T extends string | number> = Array<ComboboxOption<T>> | ((inputValue: string) => Promise<Array<ComboboxOption<T>>>);
/**
 * Abstracts away sync/async options for combobox components.
 * It also filters options based on the user's input.
 *
 * Returns:
 *  - options either filtered by user's input, or from async options fn
 *  - function to call when user types (to filter, or call async fn)
 *  - loading and error states
 */
export declare function useOptions<T extends string | number>(rawOptions: AsyncOptions<T>, createCustomValue: boolean): {
    options: ComboboxOption<T>[];
    groupStartIndices: Map<string | undefined, number>;
    updateOptions: (inputValue: string) => void;
    asyncLoading: boolean;
    asyncError: boolean;
};
/**
 * Sorts options by group and returns the sorted options and the starting index of each group
 */
export declare function sortByGroup<T extends string | number>(options: Array<ComboboxOption<T>>): {
    options: ComboboxOption<T>[];
    groupStartIndices: Map<string | undefined, number>;
};
export {};
