import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo } from 'react';
import { Trans } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { ActionButton } from '../Actions/ActionButton.mjs';
import { Button } from '../Button/Button.mjs';
import { DataLinkButton } from '../DataLinks/DataLinkButton.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';

"use strict";
const ADD_ANNOTATION_ID = "add-annotation-button";
function makeRenderLinksOrActions(renderOneClickTrans, renderItem, itemGap) {
  const renderLinksOrActions = (items, styles) => {
    if (items.length === 0) {
      return;
    }
    const oneClickItem = items.find((item) => item.oneClick === true);
    if (oneClickItem != null) {
      return /* @__PURE__ */ jsx("div", { className: styles.dataLinks, children: /* @__PURE__ */ jsx(Stack, { direction: "column", justifyContent: "flex-start", gap: 0.5, children: /* @__PURE__ */ jsxs("span", { className: styles.oneClickWrapper, children: [
        /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "lg", className: styles.infoIcon }),
        renderOneClickTrans(oneClickItem.title)
      ] }) }) });
    }
    return /* @__PURE__ */ jsx("div", { className: styles.dataLinks, children: /* @__PURE__ */ jsx(Stack, { direction: "column", justifyContent: "flex-start", gap: itemGap, children: items.map((item, i) => renderItem(item, i, styles)) }) });
  };
  return renderLinksOrActions;
}
const renderDataLinks = makeRenderLinksOrActions(
  (title) => /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-ui.viz-tooltip.footer-click-to-navigate", children: [
    "Click to open ",
    { linkTitle: title }
  ] }),
  (item, i, styles) => /* @__PURE__ */ jsx(DataLinkButton, { link: item, buttonProps: { className: styles.dataLinkButton, fill: "text" } }, i),
  0.5
);
const renderActions = makeRenderLinksOrActions(
  (title) => /* @__PURE__ */ jsxs(Trans, { i18nKey: "grafana-ui.viz-tooltip.footer-click-to-action", children: [
    "Click to ",
    { actionTitle: title }
  ] }),
  (item, i) => /* @__PURE__ */ jsx(ActionButton, { action: item, variant: "secondary" }, i)
);
const VizTooltipFooter = ({ dataLinks, actions = [], annotate }) => {
  const styles = useStyles2(getStyles);
  const hasOneClickLink = useMemo(() => dataLinks.some((link) => link.oneClick === true), [dataLinks]);
  const hasOneClickAction = useMemo(() => actions.some((action) => action.oneClick === true), [actions]);
  return /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
    !hasOneClickAction && renderDataLinks(dataLinks, styles),
    !hasOneClickLink && renderActions(actions, styles),
    !hasOneClickLink && !hasOneClickAction && annotate != null && /* @__PURE__ */ jsx("div", { className: styles.addAnnotations, children: /* @__PURE__ */ jsx(Button, { icon: "comment-alt", variant: "secondary", size: "sm", id: ADD_ANNOTATION_ID, onClick: annotate, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.viz-tooltip.footer-add-annotation", children: "Add annotation" }) }) })
  ] });
};
const getStyles = (theme) => ({
  wrapper: css({
    display: "flex",
    flexDirection: "column",
    flex: 1,
    padding: theme.spacing(0)
  }),
  dataLinks: css({
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(1)
  }),
  addAnnotations: css({
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(1)
  }),
  dataLinkButton: css({
    cursor: "pointer",
    "&:hover": {
      textDecoration: "underline",
      background: "none"
    },
    padding: 0,
    height: "auto",
    "& span": {
      whiteSpace: "normal",
      textAlign: "left"
    }
  }),
  oneClickWrapper: css({
    display: "flex",
    alignItems: "center"
  }),
  infoIcon: css({
    color: theme.colors.primary.main,
    paddingRight: theme.spacing(0.5)
  })
});

export { ADD_ANNOTATION_ID, VizTooltipFooter };
//# sourceMappingURL=VizTooltipFooter.mjs.map
