import { jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import * as React from 'react';
import SVG from 'react-inlinesvg';
import { isIconName } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { spin } from '../../utils/keyframes.mjs';
import { getSvgSize, getIconPath } from './utils.mjs';

"use strict";
const getIconStyles = (theme) => {
  return {
    icon: css({
      display: "inline-block",
      fill: "currentColor",
      flexShrink: 0,
      label: "Icon",
      // line-height: 0; is needed for correct icon alignment in Safari
      lineHeight: 0,
      verticalAlign: "middle"
    }),
    orange: css({
      fill: theme.v1.palette.orange
    }),
    spin: css({
      [theme.transitions.handleMotion("no-preference", "reduce")]: {
        animation: `${spin} 2s infinite linear`
      }
    })
  };
};
const Icon = React.forwardRef(
  ({ size = "md", type = "default", name, className, style, title = "", ...rest }, ref) => {
    const styles = useStyles2(getIconStyles);
    if (!isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    const iconName = name === "fa fa-spinner" ? "spinner" : name;
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const svgPath = getIconPath(iconName, type);
    const composedClassName = cx(
      styles.icon,
      className,
      type === "mono" ? { [styles.orange]: name === "favorite" } : "",
      {
        [styles.spin]: iconName === "spinner"
      }
    );
    return /* @__PURE__ */ jsx(
      SVG,
      {
        "aria-hidden": rest.tabIndex === void 0 && !title && !rest["aria-label"] && !rest["aria-labelledby"] && !rest["aria-describedby"],
        innerRef: ref,
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: composedClassName,
        style,
        loader: /* @__PURE__ */ jsx(
          "div",
          {
            className: cx(
              css({
                width: svgWid,
                height: svgHgt
              }),
              composedClassName
            )
          }
        ),
        ...rest
      }
    );
  }
);
Icon.displayName = "Icon";

export { Icon };
//# sourceMappingURL=Icon.mjs.map
