import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { t, Trans } from '@grafana/i18n';
import { useStyles2, Card, Button } from '@grafana/ui';
import { promqlGrammar } from '../promql.mjs';
import { RawQuery } from './shared/RawQuery.mjs';
import { promQueryModeller } from './shared/modeller_instance.mjs';

"use strict";
const QueryPattern = (props) => {
  const { pattern, onPatternSelect, hasNewQueryOption, hasPreviousQuery, selectedPatternName, setSelectedPatternName } = props;
  const styles = useStyles2(getStyles);
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxs(Card, { className: styles.card, children: [
    /* @__PURE__ */ jsx(Card.Heading, { children: pattern.name }),
    /* @__PURE__ */ jsx("div", { className: styles.rawQueryContainer, children: /* @__PURE__ */ jsx(
      RawQuery,
      {
        "aria-label": t(
          "grafana-prometheus.querybuilder.query-pattern.aria-label-raw-query",
          "{{patternName}} raw query",
          {
            patternName: pattern.name
          }
        ),
        query: promQueryModeller.renderQuery({
          metric: "",
          labels: [],
          operations: pattern.operations,
          binaryQueries: pattern.binaryQueries
        }),
        lang,
        className: styles.rawQuery
      }
    ) }),
    /* @__PURE__ */ jsx(Card.Actions, { children: selectedPatternName !== pattern.name ? /* @__PURE__ */ jsx(
      Button,
      {
        size: "sm",
        "aria-label": t(
          "grafana-prometheus.querybuilder.query-pattern.aria-label-use-this-query-button",
          "use this query button"
        ),
        onClick: () => {
          if (hasPreviousQuery) {
            setSelectedPatternName(pattern.name);
          } else {
            onPatternSelect(pattern);
          }
        },
        children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.use-this-query", children: "Use this query" })
      }
    ) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("div", { className: styles.spacing, children: `If you would like to use this query, ${hasNewQueryOption ? "you can either apply this query pattern or create a new query" : "this query pattern will be applied to your current query"}.` }),
      /* @__PURE__ */ jsx(
        Button,
        {
          size: "sm",
          "aria-label": t("grafana-prometheus.querybuilder.query-pattern.aria-label-back-button", "back button"),
          fill: "outline",
          onClick: () => setSelectedPatternName(null),
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.back", children: "Back" })
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          size: "sm",
          "aria-label": t(
            "grafana-prometheus.querybuilder.query-pattern.aria-label-apply-query-starter-button",
            "apply query starter button"
          ),
          onClick: () => {
            onPatternSelect(pattern);
          },
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.apply-query", children: "Apply query" })
        }
      ),
      hasNewQueryOption && /* @__PURE__ */ jsx(
        Button,
        {
          size: "sm",
          "aria-label": t(
            "grafana-prometheus.querybuilder.query-pattern.aria-label-create-new-query-button",
            "create new query button"
          ),
          onClick: () => {
            onPatternSelect(pattern, true);
          },
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.query-pattern.create-new-query", children: "Create new query" })
        }
      )
    ] }) })
  ] });
};
const getStyles = (theme) => {
  return {
    card: css({
      width: "49.5%",
      display: "flex",
      flexDirection: "column"
    }),
    rawQueryContainer: css({
      flexGrow: 1
    }),
    rawQuery: css({
      backgroundColor: theme.colors.background.primary,
      padding: theme.spacing(1),
      marginTop: theme.spacing(1)
    }),
    spacing: css({
      marginBottom: theme.spacing(1)
    })
  };
};

export { QueryPattern };
//# sourceMappingURL=QueryPattern.mjs.map
