import { DataQueryRequest } from '@grafana/data';
import { DataQuery } from '@grafana/schema';
/**
 * @alpha Experimental: Plugins implementing MigrationHandler interface will automatically have their queries migrated.
 */
export interface MigrationHandler {
    hasBackendMigration: boolean;
    shouldMigrate(query: DataQuery): boolean;
}
export declare function isMigrationHandler(object: unknown): object is MigrationHandler;
/**
 * @alpha Experimental: Calls migration endpoint with one query. Requires grafanaAPIServerWithExperimentalAPIs or datasourceAPIServers feature toggle.
 */
export declare function migrateQuery<TQuery extends DataQuery>(datasource: MigrationHandler, query: TQuery): Promise<TQuery>;
/**
 * @alpha Experimental: Calls migration endpoint with multiple queries. Requires grafanaAPIServerWithExperimentalAPIs or datasourceAPIServers feature toggle.
 */
export declare function migrateRequest<TQuery extends DataQuery>(datasource: MigrationHandler, request: DataQueryRequest<TQuery>): Promise<DataQueryRequest<TQuery>>;
