import { HTMLProps } from 'react';
export interface Props extends Omit<HTMLProps<HTMLInputElement>, 'value'> {
    value?: boolean;
    /** Show an invalid state around the input */
    invalid?: boolean;
}
export declare const Switch: import("react").ForwardRefExoticComponent<Omit<Props, "ref"> & import("react").RefAttributes<HTMLInputElement>>;
export interface InlineSwitchProps extends Props {
    /** Label to show next to the switch */
    showLabel?: boolean;
    /** Make inline switch's background and border transparent */
    transparent?: boolean;
}
export declare const InlineSwitch: import("react").ForwardRefExoticComponent<Omit<InlineSwitchProps, "ref"> & import("react").RefAttributes<HTMLInputElement>>;
