import { jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { getCellLinks } from '../../../utils/table.mjs';
import { renderSingleLink, DataLinksActionsTooltip } from '../DataLinksActionsTooltip.mjs';
import '../types.mjs';
import { getCellOptions, getDataLinksActionsTooltipUtils, tooltipOnClickHandler } from '../utils.mjs';
import { TableCellDisplayMode } from '@grafana/schema';

"use strict";
const DATALINKS_HEIGHT_OFFSET = 10;
const ImageCell = (props) => {
  const { field, cell, tableStyles, row, cellProps } = props;
  const cellOptions = getCellOptions(field);
  const { title, alt } = cellOptions.type === TableCellDisplayMode.Image ? cellOptions : { title: void 0, alt: void 0 };
  const displayValue = field.display(cell.value);
  const links = getCellLinks(field, row) || [];
  const [tooltipCoords, setTooltipCoords] = useState();
  const { shouldShowLink, hasMultipleLinksOrActions } = getDataLinksActionsTooltipUtils(links);
  const shouldShowTooltip = hasMultipleLinksOrActions && tooltipCoords !== void 0;
  const img = /* @__PURE__ */ jsx(
    "img",
    {
      style: { height: tableStyles.cellHeight - DATALINKS_HEIGHT_OFFSET, width: "auto" },
      src: displayValue.text,
      className: tableStyles.imageCell,
      alt,
      title
    }
  );
  return (
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
    /* @__PURE__ */ jsx(
      "div",
      {
        ...cellProps,
        className: tableStyles.cellContainer,
        style: { ...cellProps.style, cursor: hasMultipleLinksOrActions ? "context-menu" : "auto" },
        onClick: tooltipOnClickHandler(setTooltipCoords),
        children: shouldShowLink ? renderSingleLink(links[0], img) : shouldShowTooltip ? /* @__PURE__ */ jsx(
          DataLinksActionsTooltip,
          {
            links,
            value: img,
            coords: tooltipCoords,
            onTooltipClose: () => setTooltipCoords(void 0)
          }
        ) : img
      }
    )
  );
};

export { ImageCell };
//# sourceMappingURL=ImageCell.mjs.map
