import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { DragDropContext, Droppable } from '@hello-pangea/dnd';
import { cloneDeep } from 'lodash';
import { useState, useEffect } from 'react';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { Button } from '../../Button/Button.mjs';
import { Modal } from '../../Modal/Modal.mjs';
import { DataLinksListItemBase } from './DataLinksListItemBase.mjs';

"use strict";
function DataLinksInlineEditorBase({
  type,
  items,
  onChange,
  data,
  children
}) {
  const [editIndex, setEditIndex] = useState(null);
  const [isNew, setIsNew] = useState(false);
  const [itemsSafe, setItemsSafe] = useState([]);
  useEffect(() => {
    setItemsSafe(items != null ? items : []);
  }, [items]);
  const styles = useStyles2(getDataLinksInlineEditorStyles);
  const isEditing = editIndex !== null;
  const _onChange = (index, item) => {
    var _a, _b, _c;
    if (isNew) {
      const title = item.title;
      const url = (_c = (_b = item.url) != null ? _b : (_a = item.fetch) == null ? void 0 : _a.url) != null ? _c : "";
      if (title.trim() === "" && url.trim() === "") {
        setIsNew(false);
        setEditIndex(null);
        return;
      } else {
        setEditIndex(null);
        setIsNew(false);
      }
    }
    if (item.oneClick === true) {
      itemsSafe.forEach((item2) => {
        if (item2.oneClick) {
          item2.oneClick = false;
        }
      });
    }
    const update = cloneDeep(itemsSafe);
    update[index] = item;
    onChange(update);
    setEditIndex(null);
  };
  const _onCancel = (index) => {
    if (isNew) {
      setIsNew(false);
    }
    setEditIndex(null);
  };
  const onDataLinkAdd = () => {
    let update = cloneDeep(itemsSafe);
    setEditIndex(update.length);
    setIsNew(true);
  };
  const onDataLinkRemove = (index) => {
    const update = cloneDeep(itemsSafe);
    update.splice(index, 1);
    onChange(update);
  };
  const onDragEnd = (result) => {
    if (items == null || result.destination == null) {
      return;
    }
    const update = cloneDeep(itemsSafe);
    const link = update[result.source.index];
    update.splice(result.source.index, 1);
    update.splice(result.destination.index, 0, link);
    setItemsSafe(update);
    onChange(update);
  };
  const getItemText = (action) => {
    let text = "";
    switch (type) {
      case "link":
        text = action === "edit" ? t("grafana-ui.data-links-inline-editor.edit-link", "Edit link") : t("grafana-ui.data-links-inline-editor.add-link", "Add link");
        break;
      case "action":
        text = action === "edit" ? t("grafana-ui.action-editor.inline.edit-action", "Edit action") : t("grafana-ui.action-editor.inline.add-action", "Add action");
        break;
    }
    return text;
  };
  return /* @__PURE__ */ jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsx(DragDropContext, { onDragEnd, children: /* @__PURE__ */ jsx(Droppable, { droppableId: "sortable-links", direction: "vertical", children: (provided) => /* @__PURE__ */ jsxs("div", { className: styles.wrapper, ref: provided.innerRef, ...provided.droppableProps, children: [
      itemsSafe.map((item, idx) => {
        const key = `${item.title}/${idx}`;
        return /* @__PURE__ */ jsx(
          DataLinksListItemBase,
          {
            index: idx,
            item,
            onChange: _onChange,
            onEdit: () => setEditIndex(idx),
            onRemove: () => onDataLinkRemove(idx),
            data,
            itemKey: key
          },
          key
        );
      }),
      provided.placeholder
    ] }) }) }),
    isEditing && editIndex !== null && /* @__PURE__ */ jsx(
      Modal,
      {
        title: getItemText(isNew ? "add" : "edit"),
        isOpen: true,
        closeOnBackdropClick: false,
        onDismiss: () => {
          _onCancel(editIndex);
        },
        children: children(itemsSafe[editIndex], editIndex, _onChange, _onCancel)
      }
    ),
    /* @__PURE__ */ jsx(Button, { size: "sm", icon: "plus", onClick: onDataLinkAdd, variant: "secondary", className: styles.button, children: getItemText("add") })
  ] });
}
const getDataLinksInlineEditorStyles = (theme) => ({
  container: css({
    position: "relative"
  }),
  wrapper: css({
    marginBottom: theme.spacing(2),
    display: "flex",
    flexDirection: "column"
  }),
  button: css({
    marginLeft: theme.spacing(1)
  })
});

export { DataLinksInlineEditorBase };
//# sourceMappingURL=DataLinksInlineEditorBase.mjs.map
