import { Registry, RegistryItem } from './Registry';
export declare enum UnaryOperationID {
    Abs = "abs",
    Exp = "exp",
    Ln = "ln",
    Round = "round",
    Floor = "floor",
    Ceil = "ceil",
    Percent = "percent"
}
export type UnaryOperation = (value: number, total?: number) => number;
interface UnaryOperatorInfo extends RegistryItem {
    operation: UnaryOperation;
    unaryOperationID: UnaryOperationID;
}
export declare const unaryOperators: Registry<UnaryOperatorInfo>;
export {};
