import { jsxs, jsx } from 'react/jsx-runtime';
import { Trans } from '@grafana/i18n';
import { Button } from '../Button/Button.mjs';
import { InlineField } from '../Forms/InlineField.mjs';
import { InlineFieldRow } from '../Forms/InlineFieldRow.mjs';
import { Input } from '../Input/Input.mjs';
import { TextArea } from '../TextArea/TextArea.mjs';

"use strict";
const CertificationKey = ({ hasCert, label, onChange, onClick, placeholder }) => {
  return /* @__PURE__ */ jsxs(InlineFieldRow, { children: [
    /* @__PURE__ */ jsx(InlineField, { label, labelWidth: 14, disabled: hasCert, children: hasCert ? /* @__PURE__ */ jsx(Input, { type: "text", value: "configured", width: 24 }) : /* @__PURE__ */ jsx(TextArea, { rows: 7, onChange, placeholder, required: true }) }),
    hasCert && /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick, style: { marginLeft: 4 }, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-source-settings.cert-key-reset", children: "Reset" }) })
  ] });
};

export { CertificationKey };
//# sourceMappingURL=CertificationKey.mjs.map
