import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { useMemo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { Trans, t } from '@grafana/i18n';
import { useStyles2, Label, Stack, Button } from '@grafana/ui';
import { EMPTY_SELECTOR } from '../../constants.mjs';
import { useMetricsBrowser } from './MetricsBrowserContext.mjs';
import { getStylesSelectorActions } from './styles.mjs';

"use strict";
function SelectorActions() {
  const styles = useStyles2(getStylesSelectorActions);
  const { validationStatus, onValidationClick, getSelector, onChange, status, err, onClearClick } = useMetricsBrowser();
  const selector = getSelector();
  const onClickRunQuery = () => {
    onChange(selector);
  };
  const onClickRunRateQuery = () => {
    const query = `rate(${selector}[$__rate_interval])`;
    onChange(query);
  };
  const empty = useMemo(() => selector === EMPTY_SELECTOR, [selector]);
  return /* @__PURE__ */ jsxs("div", { className: styles.section, children: [
    /* @__PURE__ */ jsx(Label, { children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.selector-actions.resulting-selector", children: "4. Resulting selector" }) }),
    /* @__PURE__ */ jsx(
      "div",
      {
        "aria-label": t("grafana-prometheus.components.selector-actions.aria-label-selector", "selector"),
        className: styles.selector,
        children: selector
      }
    ),
    validationStatus && /* @__PURE__ */ jsx("div", { className: styles.validationStatus, children: validationStatus }),
    /* @__PURE__ */ jsxs(Stack, { children: [
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useQuery,
          "aria-label": t(
            "grafana-prometheus.components.selector-actions.aria-label-use-selector-for-query-button",
            "Use selector for query button"
          ),
          disabled: empty,
          onClick: onClickRunQuery,
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.selector-actions.use-query", children: "Use query" })
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.useAsRateQuery,
          "aria-label": t(
            "grafana-prometheus.components.selector-actions.aria-label-use-selector-as-metrics-button",
            "Use selector as metrics button"
          ),
          variant: "secondary",
          disabled: empty,
          onClick: onClickRunRateQuery,
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.selector-actions.use-as-rate-query", children: "Use as rate query" })
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.validateSelector,
          "aria-label": t(
            "grafana-prometheus.components.selector-actions.aria-label-validate-submit-button",
            "Validate submit button"
          ),
          variant: "secondary",
          disabled: empty,
          onClick: onValidationClick,
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.selector-actions.validate-selector", children: "Validate selector" })
        }
      ),
      /* @__PURE__ */ jsx(
        Button,
        {
          "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsBrowser.clear,
          "aria-label": t(
            "grafana-prometheus.components.selector-actions.aria-label-selector-clear-button",
            "Selector clear button"
          ),
          variant: "secondary",
          onClick: onClearClick,
          children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.components.selector-actions.clear", children: "Clear" })
        }
      ),
      /* @__PURE__ */ jsx("div", { className: cx(styles.status, (status || err) && styles.statusShowing), children: /* @__PURE__ */ jsx("span", { className: err ? styles.error : "", children: err || status }) })
    ] })
  ] });
}

export { SelectorActions };
//# sourceMappingURL=SelectorActions.mjs.map
