import { jsx } from 'react/jsx-runtime';
import { createContext, useCallback, useMemo, useContext } from 'react';
import { buildSelector } from './selectorBuilder.mjs';
import { useMetricsLabelsValues } from './useMetricsLabelsValues.mjs';

"use strict";
const MetricsBrowserContext = createContext(void 0);
function MetricsBrowserProvider({
  children,
  timeRange,
  languageProvider,
  onChange
}) {
  const {
    err,
    setErr,
    status,
    setStatus,
    seriesLimit,
    setSeriesLimit,
    validationStatus,
    metrics,
    labelKeys,
    labelValues,
    selectedMetric,
    selectedLabelKeys,
    selectedLabelValues,
    handleSelectedMetricChange,
    handleSelectedLabelKeyChange,
    handleSelectedLabelValueChange,
    handleValidation,
    handleClear
  } = useMetricsLabelsValues(timeRange, languageProvider);
  const getSelector = useCallback(
    () => buildSelector(selectedMetric, selectedLabelValues),
    [selectedLabelValues, selectedMetric]
  );
  const value = useMemo(
    () => ({
      err,
      setErr,
      status,
      setStatus,
      seriesLimit,
      setSeriesLimit,
      validationStatus,
      onChange,
      getSelector,
      metrics,
      labelKeys,
      labelValues,
      selectedMetric,
      selectedLabelKeys,
      selectedLabelValues,
      onMetricClick: handleSelectedMetricChange,
      onLabelKeyClick: handleSelectedLabelKeyChange,
      onLabelValueClick: handleSelectedLabelValueChange,
      onValidationClick: handleValidation,
      onClearClick: handleClear
    }),
    [
      err,
      setErr,
      status,
      setStatus,
      seriesLimit,
      setSeriesLimit,
      validationStatus,
      onChange,
      metrics,
      getSelector,
      labelKeys,
      labelValues,
      selectedMetric,
      selectedLabelKeys,
      selectedLabelValues,
      handleSelectedLabelKeyChange,
      handleSelectedLabelValueChange,
      handleSelectedMetricChange,
      handleValidation,
      handleClear
    ]
  );
  return /* @__PURE__ */ jsx(MetricsBrowserContext.Provider, { value, children });
}
function useMetricsBrowser() {
  const context = useContext(MetricsBrowserContext);
  if (context === void 0) {
    throw new Error("useMetricsBrowser must be used within a MetricsBrowserProvider");
  }
  return context;
}

export { MetricsBrowserProvider, useMetricsBrowser };
//# sourceMappingURL=MetricsBrowserContext.mjs.map
