import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useRef, useState } from 'react';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { Icon } from '../../../Icon/Icon.mjs';
import { Popover } from '../../../Tooltip/Popover.mjs';
import { REGEX_OPERATOR } from './FilterList.mjs';
import { FilterPopup } from './FilterPopup.mjs';

"use strict";
const Filter = ({
  name,
  rows,
  filter,
  setFilter,
  field,
  crossFilterOrder,
  crossFilterRows,
  iconClassName
}) => {
  var _a, _b, _c;
  const filterValue = (_a = filter[name]) == null ? void 0 : _a.filtered;
  const filterIndex = crossFilterOrder.indexOf(name);
  let filteredRows;
  if (filterIndex > 0) {
    const previousFilterName = crossFilterOrder[filterIndex - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else if (filterIndex === -1 && crossFilterOrder.length > 0) {
    const previousFilterName = crossFilterOrder[crossFilterOrder.length - 1];
    filteredRows = crossFilterRows[previousFilterName];
  } else {
    filteredRows = rows;
  }
  const ref = useRef(null);
  const [isPopoverVisible, setPopoverVisible] = useState(false);
  const styles = useStyles2(getStyles);
  const filterEnabled = Boolean(filterValue);
  const [searchFilter, setSearchFilter] = useState(((_b = filter[name]) == null ? void 0 : _b.searchFilter) || "");
  const [operator, setOperator] = useState(((_c = filter[name]) == null ? void 0 : _c.operator) || REGEX_OPERATOR);
  return /* @__PURE__ */ jsxs(
    "button",
    {
      className: styles.headerFilter,
      ref,
      type: "button",
      onClick: (ev) => {
        setPopoverVisible(true);
        ev.stopPropagation();
      },
      children: [
        /* @__PURE__ */ jsx(Icon, { name: "filter", className: cx(iconClassName, { [styles.filterIconEnabled]: filterEnabled }) }),
        isPopoverVisible && ref.current && /* @__PURE__ */ jsx(
          Popover,
          {
            content: /* @__PURE__ */ jsx(
              FilterPopup,
              {
                name,
                rows: filteredRows,
                filterValue,
                setFilter,
                field,
                onClose: () => setPopoverVisible(false),
                searchFilter,
                setSearchFilter,
                operator,
                setOperator
              }
            ),
            onKeyDown: (event) => {
              if (event.key === " ") {
                event.stopPropagation();
              }
            },
            placement: "bottom-start",
            referenceElement: ref.current,
            show: true
          }
        )
      ]
    }
  );
};
const getStyles = (theme) => ({
  headerFilter: css({
    background: "transparent",
    border: "none",
    label: "headerFilter",
    padding: 0,
    alignSelf: "flex-end"
  }),
  filterIconEnabled: css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  })
});

export { Filter };
//# sourceMappingURL=Filter.mjs.map
