import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import * as React from 'react';
import { Component, createRef } from 'react';
import { withTheme2 } from '../../themes/ThemeContext.mjs';
import { stylesFactory } from '../../themes/stylesFactory.mjs';
import { closePopover } from '../../utils/closePopover.mjs';
import { Popover } from '../Tooltip/Popover.mjs';
import { PopoverController } from '../Tooltip/PopoverController.mjs';
import { ColorPickerPopover } from './ColorPickerPopover.mjs';
import { ColorSwatch } from './ColorSwatch.mjs';
import { SeriesColorPickerPopover } from './SeriesColorPickerPopover.mjs';

"use strict";
const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends Component {
    constructor() {
      super(...arguments);
      this.pickerTriggerRef = createRef();
    }
    render() {
      const { theme, children, onChange, color } = this.props;
      const styles = getStyles(theme);
      const popoverElement = React.createElement(popover, {
        ...{ ...this.props, children: null },
        onChange
      });
      return /* @__PURE__ */ jsx(PopoverController, { content: popoverElement, hideAfter: 300, children: (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ jsxs(Fragment, { children: [
          this.pickerTriggerRef.current && /* @__PURE__ */ jsx(
            Popover,
            {
              ...popperProps,
              referenceElement: this.pickerTriggerRef.current,
              wrapperClassName: styles.colorPicker,
              onMouseLeave: hidePopper,
              onMouseEnter: showPopper,
              onKeyDown: (event) => closePopover(event, hidePopper)
            }
          ),
          children ? children({
            ref: this.pickerTriggerRef,
            showColorPicker: showPopper,
            hideColorPicker: hidePopper
          }) : /* @__PURE__ */ jsx(
            ColorSwatch,
            {
              ref: this.pickerTriggerRef,
              onClick: showPopper,
              onMouseLeave: hidePopper,
              color: theme.visualization.getColorByName(color || "#000000"),
              "aria-label": color
            }
          )
        ] });
      } });
    }
  }, _a.displayName = displayName, _a;
};
const ColorPicker = withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles = stylesFactory((theme) => {
  return {
    colorPicker: css({
      position: "absolute",
      zIndex: theme.zIndex.tooltip,
      color: theme.colors.text.primary,
      maxWidth: "400px",
      fontSize: theme.typography.size.sm
    })
  };
});

export { ColorPicker, SeriesColorPicker, colorPickerFactory };
//# sourceMappingURL=ColorPicker.mjs.map
