import { calculateFieldTransformer } from './transformers/calculateField.mjs';
import { concatenateTransformer } from './transformers/concat.mjs';
import { convertFieldTypeTransformer } from './transformers/convertFieldType.mjs';
import { ensureColumnsTransformer } from './transformers/ensureColumns.mjs';
import { filterFieldsTransformer, filterFramesTransformer } from './transformers/filter.mjs';
import { filterFieldsByNameTransformer } from './transformers/filterByName.mjs';
import { filterFramesByRefIdTransformer } from './transformers/filterByRefId.mjs';
import { filterByValueTransformer } from './transformers/filterByValue.mjs';
import { formatStringTransformer } from './transformers/formatString.mjs';
import { formatTimeTransformer } from './transformers/formatTime.mjs';
import { groupByTransformer } from './transformers/groupBy.mjs';
import { groupToNestedTable } from './transformers/groupToNestedTable.mjs';
import { groupingToMatrixTransformer } from './transformers/groupingToMatrix.mjs';
import { histogramTransformer } from './transformers/histogram.mjs';
import { joinByFieldTransformer } from './transformers/joinByField.mjs';
import { labelsToFieldsTransformer } from './transformers/labelsToFields.mjs';
import { limitTransformer } from './transformers/limit.mjs';
import { mergeTransformer } from './transformers/merge.mjs';
import { noopTransformer } from './transformers/noop.mjs';
import { orderFieldsTransformer } from './transformers/order.mjs';
import { organizeFieldsTransformer } from './transformers/organize.mjs';
import { reduceTransformer } from './transformers/reduce.mjs';
import { renameFieldsTransformer } from './transformers/rename.mjs';
import { renameByRegexTransformer } from './transformers/renameByRegex.mjs';
import { seriesToRowsTransformer } from './transformers/seriesToRows.mjs';
import { sortByTransformer } from './transformers/sortBy.mjs';
import { transposeTransformer } from './transformers/transpose.mjs';

"use strict";
const standardTransformers = {
  noopTransformer,
  filterFieldsTransformer,
  filterFieldsByNameTransformer,
  filterFramesTransformer,
  filterFramesByRefIdTransformer,
  filterByValueTransformer,
  formatStringTransformer,
  formatTimeTransformer,
  orderFieldsTransformer,
  organizeFieldsTransformer,
  reduceTransformer,
  concatenateTransformer,
  calculateFieldTransformer,
  joinByFieldTransformer,
  /** @deprecated */
  seriesToColumnsTransformer: joinByFieldTransformer,
  seriesToRowsTransformer,
  renameFieldsTransformer,
  labelsToFieldsTransformer,
  ensureColumnsTransformer,
  groupByTransformer,
  sortByTransformer,
  mergeTransformer,
  renameByRegexTransformer,
  histogramTransformer,
  convertFieldTypeTransformer,
  groupingToMatrixTransformer,
  limitTransformer,
  groupToNestedTable,
  transposeTransformer
};

export { standardTransformers };
//# sourceMappingURL=transformers.mjs.map
