import { TimeRange } from '@grafana/data';
import { PrometheusLanguageProviderInterface } from '../../language_provider';
import { Metric } from './MetricsBrowserContext';
export declare const useMetricsLabelsValues: (timeRange: TimeRange, languageProvider: PrometheusLanguageProviderInterface) => {
    err: string;
    setErr: import("react").Dispatch<import("react").SetStateAction<string>>;
    status: string;
    setStatus: import("react").Dispatch<import("react").SetStateAction<string>>;
    seriesLimit: number;
    setSeriesLimit: import("react").Dispatch<import("react").SetStateAction<number>>;
    validationStatus: string;
    metrics: Metric[];
    labelKeys: string[];
    labelValues: Record<string, string[]>;
    selectedMetric: string;
    selectedLabelKeys: string[];
    selectedLabelValues: Record<string, string[]>;
    handleSelectedMetricChange: (metricName: string) => Promise<void>;
    handleSelectedLabelKeyChange: (labelKey: string) => Promise<void>;
    handleSelectedLabelValueChange: (labelKey: string, labelValue: string, isSelected: boolean) => Promise<void>;
    handleValidation: () => Promise<void>;
    handleClear: () => void;
    buildSafeSelector: (metric: string, labelValues: Record<string, string[]>) => string | undefined;
    loadSelectedLabelsFromStorage: (availableLabelKeys: string[]) => any;
    fetchMetrics: (safeSelector?: string) => Promise<{
        name: string;
        details: string | undefined;
    }[]>;
    fetchLabelKeys: (safeSelector?: string) => Promise<string[]>;
    fetchLabelValues: (labelKeys: string[], safeSelector?: string) => Promise<Record<string, string[]>[]>;
};
