import { IconName } from '../../types/icon';
import { OnTagClick } from './Tag';
export interface Props {
    /** Maximum number of the tags to display */
    displayMax?: number;
    /** Names of the tags to display */
    tags: string[];
    /** Callback when the tag is clicked */
    onClick?: OnTagClick;
    /** Custom styles for the wrapper component */
    className?: string;
    /** aria-label for the `i`-th Tag component */
    getAriaLabel?: (name: string, i: number) => string;
    getColorIndex?: (name: string, i: number) => number;
    /** Icon to show next to tag label */
    icon?: IconName;
}
export declare const TagList: import("react").NamedExoticComponent<Omit<Props & import("react").RefAttributes<HTMLUListElement>, "ref"> & {
    ref?: import("react").RefObject<HTMLUListElement> | ((instance: HTMLUListElement | null) => void | import("react").DO_NOT_USE_OR_YOU_WILL_BE_FIRED_CALLBACK_REF_RETURN_VALUES[keyof import("react").DO_NOT_USE_OR_YOU_WILL_BE_FIRED_CALLBACK_REF_RETURN_VALUES]) | null | undefined;
}> & {
    readonly type: import("react").ForwardRefExoticComponent<Props & import("react").RefAttributes<HTMLUListElement>>;
} & {
    Skeleton: (props: unknown) => import("react/jsx-runtime").JSX.Element;
};
