import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';

"use strict";
const getStyles = (theme) => {
  return {
    text: css({
      fontSize: theme.typography.size.md,
      fontWeight: theme.typography.fontWeightMedium,
      color: theme.colors.text.primary,
      margin: 0,
      display: "flex"
    })
  };
};
const TimePickerTitle = memo(({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("h3", { className: styles.text, children });
});
TimePickerTitle.displayName = "TimePickerTitle";

export { TimePickerTitle };
//# sourceMappingURL=TimePickerTitle.mjs.map
