import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import RCCascader from 'rc-cascader';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Button } from '../Button/Button.mjs';
import { onChangeCascader, onLoadDataCascader } from '../Cascader/optionMappings.mjs';
import { getCascaderStyles } from '../Cascader/styles.mjs';
import { Icon } from '../Icon/Icon.mjs';

"use strict";
const ButtonCascader = (props) => {
  const { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled, ...rest } = props;
  const styles = useStyles2(getStyles);
  const cascaderStyles = useStyles2(getCascaderStyles);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ jsx(Icon, { name: "angle-down", className: styles.icons.right }, "down-icon")];
  }
  return /* @__PURE__ */ jsx(
    RCCascader,
    {
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: cx(cascaderStyles.dropdown, styles.popup),
      ...rest,
      expandIcon: null,
      children: /* @__PURE__ */ jsx(Button, { icon, disabled, variant, ...buttonProps != null ? buttonProps : {}, children: content })
    }
  );
};
ButtonCascader.displayName = "ButtonCascader";
const getStyles = (theme) => {
  return {
    popup: css({
      label: "popup",
      zIndex: theme.zIndex.dropdown
    }),
    icons: {
      right: css({
        margin: "1px 0 0 4px"
      }),
      left: css({
        margin: "-1px 4px 0 0"
      })
    }
  };
};

export { ButtonCascader };
//# sourceMappingURL=ButtonCascader.mjs.map
