import { jsxs, jsx } from 'react/jsx-runtime';
import { memo } from 'react';
import { Stack } from '@grafana/ui';
import { promqlGrammar } from '../../promql.mjs';
import { buildVisualQueryFromString } from '../parsing.mjs';
import { OperationExplainedBox } from '../shared/OperationExplainedBox.mjs';
import { OperationListExplained } from '../shared/OperationListExplained.mjs';
import { RawQuery } from '../shared/RawQuery.mjs';
import { promQueryModeller } from '../shared/modeller_instance.mjs';

"use strict";
const EXPLAIN_LABEL_FILTER_CONTENT = "Fetch all series matching metric name and label filters.";
const PromQueryBuilderExplained = memo(({ query }) => {
  const visQuery = buildVisualQueryFromString(query || "").query;
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxs(Stack, { gap: 0.5, direction: "column", children: [
    /* @__PURE__ */ jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsx(RawQuery, { query: `${promQueryModeller.renderQuery(visQuery)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsx(
      OperationListExplained,
      {
        stepNumber: 2,
        queryModeller: promQueryModeller,
        query: visQuery,
        lang
      }
    )
  ] });
});
PromQueryBuilderExplained.displayName = "PromQueryBuilderExplained";

export { EXPLAIN_LABEL_FILTER_CONTENT, PromQueryBuilderExplained };
//# sourceMappingURL=PromQueryBuilderExplained.mjs.map
