import { Field } from '../../types/dataFrame';
import { DataTransformerInfo } from '../../types/transformations';
export declare enum OrderByMode {
    Manual = "manual",
    Auto = "auto"
}
export declare enum Order {
    Off = "off",
    Asc = "asc",
    Desc = "desc"
}
export declare enum OrderByType {
    Name = "name",
    Label = "label"
}
export interface OrderByItem {
    type: OrderByType;
    name?: string;
    desc?: boolean;
}
export interface OrderFieldsTransformerOptions {
    indexByName?: Record<string, number>;
    orderByMode?: OrderByMode;
    orderBy?: OrderByItem[];
}
export declare const orderFieldsTransformer: DataTransformerInfo<OrderFieldsTransformerOptions>;
export declare const createOrderFieldsComparer: (indexByName: Record<string, number>) => (a: string, b: string) => number;
/** @internal */
export declare const createFieldsOrdererAuto: (orderBy: OrderByItem[]) => (fields: Field[]) => Field<any>[];
