import { TimeRange, TimeZone } from '@grafana/data';
import { WeekStart } from './WeekStartPicker';
export interface TimeRangeInputProps {
    value: TimeRange;
    timeZone?: TimeZone;
    onChange: (timeRange: TimeRange) => void;
    onChangeTimeZone?: (timeZone: TimeZone) => void;
    hideTimeZone?: boolean;
    placeholder?: string;
    clearable?: boolean;
    /** Controls horizontal alignment of the picker menu */
    isReversed?: boolean;
    /** Controls visibility of the preset time ranges (e.g. **Last 5 minutes**) in the picker menu */
    hideQuickRanges?: boolean;
    disabled?: boolean;
    showIcon?: boolean;
    /** Which day of the week the calendar should start on. Possible values: "saturday", "sunday" or "monday" */
    weekStart?: WeekStart;
}
export declare const TimeRangeInput: ({ value, onChange, onChangeTimeZone, clearable, weekStart, hideTimeZone, timeZone, placeholder, isReversed, hideQuickRanges, disabled, showIcon, }: TimeRangeInputProps) => import("react/jsx-runtime").JSX.Element;
