import { type UserStorage as UserStorageType } from '@grafana/data';
export type UserStorageSpec = {
    data: {
        [key: string]: string;
    };
};
/**
 * A class for interacting with the backend user storage.
 * Exposed internally only to avoid misuse (wrong service name)..
 */
export declare class UserStorage implements UserStorageType {
    private service;
    private resourceName;
    private userUID;
    private canUseUserStorage;
    private storageSpec;
    constructor(service: string);
    private init;
    getItem(key: string): Promise<string | null>;
    setItem(key: string, value: string): Promise<void>;
}
export interface PluginUserStorage extends UserStorageType {
}
/**
 * A hook for interacting with the backend user storage (or local storage if not enabled).
 * @returns An scoped object for a plugin and a user with getItem and setItem functions.
 * @alpha Experimental
 */
export declare function usePluginUserStorage(): PluginUserStorage;
