import { PayloadAction } from '@reduxjs/toolkit';
import { SelectableValue } from '@grafana/data';
import { PromVisualQuery } from '../../../types';
import { HaystackDictionary, MetricsData } from '../types';
export declare const DEFAULT_RESULTS_PER_PAGE = 100;
export declare const MAXIMUM_RESULTS_PER_PAGE = 1000;
/**
 * Initial state for the metrics explorer
 * @returns
 */
export declare function initialState(query?: PromVisualQuery): MetricsModalState;
/**
 * The metrics explorer state object
 */
export interface MetricsModalState {
    /** Used for the loading spinner */
    isLoading: boolean;
    /**
     * Initial collection of metrics.
     * The frontend filters do not impact this, but
     * it is reduced by the backend search.
     */
    metrics: MetricsData;
    /** Field for disabling type select and switches that rely on metadata */
    hasMetadata: boolean;
    /** Used to display metrics and help with fuzzy order */
    nameHaystackDictionary: HaystackDictionary;
    /** Used to sort name fuzzy search by relevance */
    nameHaystackOrder: string[];
    /** Used to highlight text in fuzzy matches */
    nameHaystackMatches: string[];
    /** Used to display metrics and help with fuzzy order for search across all metadata */
    metaHaystackDictionary: HaystackDictionary;
    /** Used to sort meta fuzzy search by relevance */
    metaHaystackOrder: string[];
    /** Used to highlight text in fuzzy matches */
    metaHaystackMatches: string[];
    /** Total results computed on initialization */
    totalMetricCount: number;
    /** Set after filtering metrics */
    filteredMetricCount: number | null;
    /** Pagination field for showing results in table */
    resultsPerPage: number;
    /** Pagination field */
    pageNum: number;
    /** The text query used to match metrics */
    fuzzySearchQuery: string;
    /** Enables the fuzzy meatadata search */
    fullMetaSearch: boolean;
    /** Includes results that are missing type and description */
    includeNullMetadata: boolean;
    /** Filter by prometheus type */
    selectedTypes: Array<SelectableValue<string>>;
    /** Filter by the series match endpoint instead of the fuzzy search */
    useBackend: boolean;
    /** Disable text wrap for descriptions in the results table */
    disableTextWrap: boolean;
    /** Display toggle switches for settings */
    showAdditionalSettings: boolean;
}
/**
 * Type for the useEffect get metadata function
 */
export type MetricsModalMetadata = {
    isLoading: boolean;
    metrics: MetricsData;
    hasMetadata: boolean;
    metaHaystackDictionary: HaystackDictionary;
    nameHaystackDictionary: HaystackDictionary;
    totalMetricCount: number;
    filteredMetricCount: number | null;
};
export declare function getSettings(visQuery: PromVisualQuery): MetricsModalSettings;
export type MetricsModalSettings = {
    useBackend?: boolean;
    disableTextWrap?: boolean;
    fullMetaSearch?: boolean;
    includeNullMetadata?: boolean;
};
export declare const stateSlice: import("@reduxjs/toolkit").Slice<MetricsModalState, {
    filterMetricsBackend: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<{
        metrics: MetricsData;
        filteredMetricCount: number;
        isLoading: boolean;
    }>) => void;
    buildMetrics: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<MetricsModalMetadata>) => void;
    setIsLoading: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<boolean>) => void;
    setFilteredMetricCount: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<number>) => void;
    setResultsPerPage: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<number>) => void;
    setPageNum: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<number>) => void;
    setFuzzySearchQuery: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<string>) => void;
    setNameHaystack: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<string[][]>) => void;
    setMetaHaystack: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<string[][]>) => void;
    setFullMetaSearch: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<boolean>) => void;
    setIncludeNullMetadata: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<boolean>) => void;
    setSelectedTypes: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<Array<SelectableValue<string>>>) => void;
    setUseBackend: (state: import("immer").WritableDraft<MetricsModalState>, action: PayloadAction<boolean>) => void;
    setDisableTextWrap: (state: import("immer").WritableDraft<MetricsModalState>) => void;
    showAdditionalSettings: (state: import("immer").WritableDraft<MetricsModalState>) => void;
}, "metrics-modal-state", "metrics-modal-state", import("@reduxjs/toolkit").SliceSelectors<MetricsModalState>>;
export declare const setIsLoading: import("@reduxjs/toolkit").ActionCreatorWithPayload<boolean, "metrics-modal-state/setIsLoading">, buildMetrics: import("@reduxjs/toolkit").ActionCreatorWithPayload<MetricsModalMetadata, "metrics-modal-state/buildMetrics">, filterMetricsBackend: import("@reduxjs/toolkit").ActionCreatorWithPayload<{
    metrics: MetricsData;
    filteredMetricCount: number;
    isLoading: boolean;
}, "metrics-modal-state/filterMetricsBackend">, setResultsPerPage: import("@reduxjs/toolkit").ActionCreatorWithPayload<number, "metrics-modal-state/setResultsPerPage">, setPageNum: import("@reduxjs/toolkit").ActionCreatorWithPayload<number, "metrics-modal-state/setPageNum">, setFuzzySearchQuery: import("@reduxjs/toolkit").ActionCreatorWithPayload<string, "metrics-modal-state/setFuzzySearchQuery">, setNameHaystack: import("@reduxjs/toolkit").ActionCreatorWithPayload<string[][], "metrics-modal-state/setNameHaystack">, setMetaHaystack: import("@reduxjs/toolkit").ActionCreatorWithPayload<string[][], "metrics-modal-state/setMetaHaystack">, setFullMetaSearch: import("@reduxjs/toolkit").ActionCreatorWithPayload<boolean, "metrics-modal-state/setFullMetaSearch">, setIncludeNullMetadata: import("@reduxjs/toolkit").ActionCreatorWithPayload<boolean, "metrics-modal-state/setIncludeNullMetadata">, setSelectedTypes: import("@reduxjs/toolkit").ActionCreatorWithPayload<SelectableValue<string>[], "metrics-modal-state/setSelectedTypes">, setUseBackend: import("@reduxjs/toolkit").ActionCreatorWithPayload<boolean, "metrics-modal-state/setUseBackend">, setDisableTextWrap: import("@reduxjs/toolkit").ActionCreatorWithoutPayload<"metrics-modal-state/setDisableTextWrap">, showAdditionalSettings: import("@reduxjs/toolkit").ActionCreatorWithoutPayload<"metrics-modal-state/showAdditionalSettings">, setFilteredMetricCount: import("@reduxjs/toolkit").ActionCreatorWithPayload<number, "metrics-modal-state/setFilteredMetricCount">;
