export interface ScopeDashboardBindingSpec {
    dashboard: string;
    scope: string;
}
export interface ScopeDashboardBindingStatus {
    dashboardTitle: string;
    groups?: string[];
}
export interface ScopeDashboardBinding {
    metadata: {
        name: string;
    };
    spec: ScopeDashboardBindingSpec;
    status: ScopeDashboardBindingStatus;
}
export type ScopeFilterOperator = 'equals' | 'not-equals' | 'regex-match' | 'regex-not-match' | 'one-of' | 'not-one-of';
export type EqualityOrMultiOperator = Extract<ScopeFilterOperator, 'equals' | 'not-equals' | 'one-of' | 'not-one-of'>;
export declare function isEqualityOrMultiOperator(value: string): value is EqualityOrMultiOperator;
export declare const scopeFilterOperatorMap: Record<string, ScopeFilterOperator>;
export declare const reverseScopeFilterOperatorMap: Record<ScopeFilterOperator, string>;
export interface ScopeSpecFilter {
    key: string;
    value: string;
    values?: string[];
    operator: ScopeFilterOperator;
}
export interface ScopeSpec {
    title: string;
    type: string;
    description: string;
    category: string;
    filters: ScopeSpecFilter[];
}
export interface Scope {
    metadata: {
        name: string;
    };
    spec: ScopeSpec;
}
export type ScopeNodeNodeType = 'container' | 'leaf';
export type ScopeNodeLinkType = 'scope';
export interface ScopeNodeSpec {
    nodeType: ScopeNodeNodeType;
    title: string;
    description?: string;
    disableMultiSelect?: boolean;
    linkId?: string;
    linkType?: ScopeNodeLinkType;
    parentName?: string;
}
export interface ScopeNode {
    metadata: {
        name: string;
    };
    spec: ScopeNodeSpec;
}
