import { SelectableValue } from '@grafana/data';
import { SelectContainer, SelectContainerProps } from './SelectContainer';
import { SelectCommonProps, MultiSelectCommonProps, SelectAsyncProps, VirtualizedSelectProps, VirtualizedSelectAsyncProps } from './types';
/** @deprecated Use Combobox component instead */
export declare function Select<T, Rest = {}>(props: SelectCommonProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
export declare function MultiSelect<T, Rest = {}>(props: MultiSelectCommonProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
export interface AsyncSelectProps<T> extends Omit<SelectCommonProps<T>, 'options'>, SelectAsyncProps<T> {
    value?: T | SelectableValue<T> | null;
}
/** @deprecated Use Combobox component instead */
export declare function AsyncSelect<T, Rest = {}>(props: AsyncSelectProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
/** @deprecated Use Combobox component instead - it's virtualised by default! */
export declare function VirtualizedSelect<T, Rest = {}>(props: VirtualizedSelectProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
/** @deprecated Use Combobox component instead - it's virtualised by default! */
export declare function AsyncVirtualizedSelect<T, Rest = {}>(props: VirtualizedSelectAsyncProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
interface AsyncMultiSelectProps<T> extends Omit<MultiSelectCommonProps<T>, 'options'>, SelectAsyncProps<T> {
    value?: Array<SelectableValue<T>>;
}
export declare function AsyncMultiSelect<T, Rest = {}>(props: AsyncMultiSelectProps<T> & Rest): import("react/jsx-runtime").JSX.Element;
export { SelectContainer, type SelectContainerProps };
