import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { components } from 'react-select';
import { toIconName } from '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { useDelayedSwitch } from '../../utils/useDelayedSwitch.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Spinner } from '../Spinner/Spinner.mjs';
import { FadeTransition } from '../transitions/FadeTransition.mjs';
import { SlideOutTransition } from '../transitions/SlideOutTransition.mjs';

"use strict";
const getStyles = (theme) => {
  return {
    singleValue: css({
      label: "singleValue",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%",
      gridArea: "1 / 1 / 2 / 3"
    }),
    spinnerWrapper: css({
      width: "16px",
      height: "16px",
      display: "inline-block",
      marginRight: "10px",
      position: "relative",
      verticalAlign: "middle",
      overflow: "hidden"
    }),
    spinnerIcon: css({
      width: "100%",
      height: "100%",
      position: "absolute"
    }),
    optionIcon: css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    disabled: css({
      color: theme.colors.text.disabled
    }),
    isOpen: css({
      color: theme.colors.text.disabled
    })
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data, isDisabled } = props;
  const styles = useStyles2(getStyles);
  const loading = useDelayedSwitch(data.loading || false, { delay: 250, duration: 750 });
  const icon = data.icon ? toIconName(data.icon) : void 0;
  return /* @__PURE__ */ jsxs(
    components.SingleValue,
    {
      ...props,
      className: cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen),
      children: [
        data.imgUrl ? /* @__PURE__ */ jsx(FadeWithImage, { loading, imgUrl: data.imgUrl, styles, alt: String((_a = data.label) != null ? _a : data.value) }) : /* @__PURE__ */ jsxs(Fragment, { children: [
          /* @__PURE__ */ jsx(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150, children: /* @__PURE__ */ jsx("div", { className: styles.spinnerWrapper, children: /* @__PURE__ */ jsx(Spinner, { className: styles.spinnerIcon, inline: true }) }) }),
          icon && /* @__PURE__ */ jsx(Icon, { name: icon, role: "img", className: styles.optionIcon })
        ] }),
        !data.hideText && children
      ]
    }
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ jsxs("div", { className: props.styles.spinnerWrapper, children: [
    /* @__PURE__ */ jsx(FadeTransition, { duration: 150, visible: props.loading, children: /* @__PURE__ */ jsx(Spinner, { className: props.styles.spinnerIcon, inline: true }) }),
    /* @__PURE__ */ jsx(FadeTransition, { duration: 150, visible: !props.loading, children: /* @__PURE__ */ jsx("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt }) })
  ] });
};

export { SingleValue };
//# sourceMappingURL=SingleValue.mjs.map
