import * as React from 'react';
import { textUtil } from '@grafana/data';

"use strict";
function RenderUserContentAsHTML({
  component,
  content,
  ...rest
}) {
  return React.createElement(component || "span", {
    dangerouslySetInnerHTML: { __html: textUtil.sanitize(content) },
    ...rest
  });
}

export { RenderUserContentAsHTML };
//# sourceMappingURL=RenderUserContentAsHTML.mjs.map
