import { jsx } from 'react/jsx-runtime';
import { chain } from 'lodash';
import { Combobox } from '@grafana/ui';
import { useListContactPoints } from '../../hooks/v0alpha1/useContactPoints.mjs';
import { getContactPointDescription } from '../../utils.mjs';

"use strict";
const collator = new Intl.Collator("en", { sensitivity: "accent" });
function ContactPointSelector(props) {
  const { currentData: contactPoints, isLoading } = useListContactPoints();
  const contactPointOptions = chain(contactPoints == null ? void 0 : contactPoints.items).toArray().map((contactPoint) => {
    var _a;
    return {
      option: {
        label: contactPoint.spec.title,
        value: (_a = contactPoint.metadata.uid) != null ? _a : contactPoint.spec.title,
        description: getContactPointDescription(contactPoint)
      },
      contactPoint
    };
  }).value().sort((a, b) => collator.compare(a.option.label, b.option.label));
  const options = contactPointOptions.map((item) => item.option);
  const handleChange = (selectedOption) => {
    if (selectedOption == null && props.isClearable) {
      props.onChange(null);
      return;
    }
    if (selectedOption) {
      const matchedOption = contactPointOptions.find(({ option }) => option.value === selectedOption.value);
      if (!matchedOption) {
        return;
      }
      props.onChange(matchedOption.contactPoint);
    }
  };
  return /* @__PURE__ */ jsx(Combobox, { ...props, loading: isLoading, options, onChange: handleChange });
}

export { ContactPointSelector };
//# sourceMappingURL=ContactPointSelector.mjs.map
