import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { InlineFormLabel } from '../FormLabel/FormLabel.mjs';

"use strict";
const FormField = ({
  label,
  tooltip,
  labelWidth = 6,
  inputWidth = 12,
  inputEl,
  className,
  interactive,
  ...inputProps
}) => {
  const styles = getStyles();
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.formField, className), children: [
    /* @__PURE__ */ jsx(InlineFormLabel, { width: labelWidth, tooltip, interactive, children: label }),
    inputEl || /* @__PURE__ */ jsx(
      "input",
      {
        type: "text",
        className: `gf-form-input ${inputWidth ? `width-${inputWidth}` : ""}`,
        ...inputProps,
        disabled: inputProps.disabled
      }
    )
  ] });
};
FormField.displayName = "FormField";
const getStyles = () => {
  return {
    formField: css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative"
    })
  };
};

export { FormField };
//# sourceMappingURL=FormField.mjs.map
