import { CSSProperties, ReactNode } from 'react';
import { SelectableValue } from './select';
export declare enum ActionType {
    Fetch = "fetch"
}
type ActionButtonCssProperties = Pick<CSSProperties, 'backgroundColor'>;
export interface Action {
    type: ActionType;
    title: string;
    [ActionType.Fetch]: FetchOptions;
    confirmation?: string;
    oneClick?: boolean;
    variables?: ActionVariable[];
    style?: ActionButtonCssProperties;
}
/**
 * Processed Action Model. The values are ready to use
 */
export interface ActionModel<T = any> {
    title: string;
    onClick: (event: any, origin?: any, actionVars?: ActionVariableInput) => void;
    confirmation: (actionVars?: ActionVariableInput) => ReactNode;
    oneClick?: boolean;
    style: ActionButtonCssProperties;
    variables?: ActionVariable[];
}
export type ActionVariable = {
    key: string;
    name: string;
    type: ActionVariableType;
};
export declare enum ActionVariableType {
    String = "string"
}
interface FetchOptions {
    method: HttpRequestMethod;
    url: string;
    body?: string;
    queryParams?: Array<[string, string]>;
    headers?: Array<[string, string]>;
}
export declare enum HttpRequestMethod {
    POST = "POST",
    PUT = "PUT",
    GET = "GET"
}
export declare const httpMethodOptions: SelectableValue[];
export declare const contentTypeOptions: SelectableValue[];
export declare const defaultActionConfig: Action;
export type ActionVariableInput = {
    [key: string]: string;
};
export {};
