"use strict";
let singleton;
function setGetObservablePluginLinks(fn) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setGetObservablePluginLinks() function should only be called once, when Grafana is starting.");
  }
  singleton = fn;
}
function getObservablePluginLinks(options) {
  if (!singleton) {
    throw new Error("getObservablePluginLinks() can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}

export { getObservablePluginLinks, setGetObservablePluginLinks };
//# sourceMappingURL=getObservablePluginLinks.mjs.map
