import { Component } from 'react';
import * as React from 'react';
import { DataFrame, TimeRange } from '@grafana/data';
import { PanelContextRoot } from '../../components/PanelChrome/PanelContext';
import { UPlotConfigBuilder } from '../../components/uPlot/config/UPlotConfigBuilder';
import { GraphNGProps } from '../GraphNG/GraphNG';
type TimeSeriesProps = Omit<GraphNGProps, 'prepConfig' | 'propsToDiff' | 'renderLegend'>;
export declare class UnthemedTimeSeries extends Component<TimeSeriesProps> {
    static contextType: React.Context<import("../../components/PanelChrome/PanelContext").PanelContext>;
    context: React.ContextType<typeof PanelContextRoot>;
    prepConfig: (alignedFrame: DataFrame, allFrames: DataFrame[], getTimeRange: () => TimeRange) => UPlotConfigBuilder;
    renderLegend: (config: UPlotConfigBuilder) => import("react/jsx-runtime").JSX.Element | null;
    render(): import("react/jsx-runtime").JSX.Element;
}
export declare const TimeSeries: React.FunctionComponent<{
    fields?: import("../GraphNG/types").XYFieldMatchers | undefined;
    width: number;
    options?: Record<string, any> | undefined;
    timeZone: import("@grafana/data").TimeZone[] | import("@grafana/data").TimeZone;
    height: number;
    legend: import("@grafana/schema").VizLegendOptions;
    structureRev?: number | undefined;
    children?: ((builder: UPlotConfigBuilder, alignedFrame: DataFrame) => React.ReactNode) | undefined;
    timeRange: TimeRange;
    frames: DataFrame[];
    renderers?: import("../../components/uPlot/config/UPlotConfigBuilder").Renderers | undefined;
    tweakScale?: ((opts: import("../../internal").ScaleProps, forField: import("@grafana/data").Field) => import("../../internal").ScaleProps) | undefined;
    tweakAxis?: ((opts: import("../../internal").AxisProps, forField: import("@grafana/data").Field) => import("../../internal").AxisProps) | undefined;
    onLegendClick?: ((event: import("../..").GraphNGLegendEvent) => void) | undefined;
    preparePlotFrame?: ((frames: DataFrame[], dimFields: import("../GraphNG/types").XYFieldMatchers) => DataFrame | null) | undefined;
}>;
export {};
