import { TimeRange } from '@grafana/data';
/**
 * Handle the behaviour of the time sync button and syncing the time range between pickers. It also takes care of
 * backward compatibility with the manually controlled isSynced prop.
 * @param options
 */
export declare function useTimeSync(options: {
    initialIsSynced?: boolean;
    value: TimeRange;
    isSyncedProp?: boolean;
    timeSyncButtonProp?: JSX.Element;
    onChangeProp: (value: TimeRange) => void;
}): {
    onChangeWithSync: (timeRange: TimeRange) => void;
    isSynced: boolean | undefined;
    timeSyncButton: false | JSX.Element | undefined;
};
