type AsyncFn<T, V> = (value: T) => Promise<V>;
/**
 * Wraps an async function to ensure that only the latest call is resolved.
 * Used to prevent a faster call being overwritten by an earlier slower call.
 */
export declare function useLatestAsyncCall<T, V>(fn: AsyncFn<T, V>): AsyncFn<T, V>;
export declare class StaleResultError extends Error {
    constructor();
}
export {};
