import { buildVisualQueryFromString } from '../querybuilder/parsing.mjs';
import { promQueryModeller } from '../querybuilder/shared/modeller_instance.mjs';
import { PromVariableQueryType } from '../types.mjs';

"use strict";
const PrometheusLabelNamesRegex = /^label_names\(\)\s*$/;
const PrometheusLabelValuesRegex = /^label_values\((?:(.+),\s*)?(.+)\)\s*$/;
const PrometheusMetricNamesRegex = /^metrics\((.+)\)\s*$/;
const PrometheusQueryResultRegex = /^query_result\((.+)\)\s*$/;
const PrometheusLabelNamesRegexWithMatch = /^label_names\((.+)\)\s*$/;
function migrateVariableQueryToEditor(rawQuery) {
  if (typeof rawQuery !== "string") {
    return rawQuery;
  }
  const queryBase = {
    refId: "PrometheusDatasource-VariableQuery",
    qryType: PromVariableQueryType.LabelNames
  };
  const labelNamesMatchQuery = rawQuery.match(PrometheusLabelNamesRegexWithMatch);
  if (labelNamesMatchQuery) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.LabelNames,
      match: labelNamesMatchQuery[1]
    };
  }
  const labelNames = rawQuery.match(PrometheusLabelNamesRegex);
  if (labelNames) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.LabelNames
    };
  }
  const labelValuesCheck = rawQuery.match(/^label_values\(/);
  if (labelValuesCheck) {
    const labelValues = rawQuery.match(PrometheusLabelValuesRegex);
    const label = labelValues ? labelValues[2] : "";
    const metric = labelValues ? labelValues[1] : "";
    if (metric) {
      const visQuery = buildVisualQueryFromString(metric);
      return {
        ...queryBase,
        qryType: PromVariableQueryType.LabelValues,
        label,
        metric: visQuery.query.metric,
        labelFilters: visQuery.query.labels
      };
    } else {
      return {
        ...queryBase,
        qryType: PromVariableQueryType.LabelValues,
        label
      };
    }
  }
  const metricNamesCheck = rawQuery.match(/^metrics\(/);
  if (metricNamesCheck) {
    const metricNames = rawQuery.match(PrometheusMetricNamesRegex);
    const metric = metricNames ? metricNames[1] : "";
    return {
      ...queryBase,
      qryType: PromVariableQueryType.MetricNames,
      metric
    };
  }
  const queryResultCheck = rawQuery.match(/^query_result\(/);
  if (queryResultCheck) {
    const queryResult = rawQuery.match(PrometheusQueryResultRegex);
    const varQuery = queryResult ? queryResult[1] : "";
    return {
      ...queryBase,
      qryType: PromVariableQueryType.VarQueryResult,
      varQuery
    };
  }
  if (!labelNames && !labelValuesCheck && !metricNamesCheck && !queryResultCheck) {
    return {
      ...queryBase,
      qryType: PromVariableQueryType.SeriesQuery,
      seriesQuery: rawQuery
    };
  }
  return queryBase;
}
function migrateVariableEditorBackToVariableSupport(QueryVariable) {
  var _a, _b, _c, _d;
  switch (QueryVariable.qryType) {
    case PromVariableQueryType.LabelNames:
      if (QueryVariable.match) {
        return `label_names(${QueryVariable.match})`;
      }
      return "label_names()";
    case PromVariableQueryType.LabelValues:
      if (QueryVariable.metric || QueryVariable.labelFilters && QueryVariable.labelFilters.length !== 0) {
        const visualQueryQuery = {
          metric: (_a = QueryVariable.metric) != null ? _a : "",
          labels: (_b = QueryVariable.labelFilters) != null ? _b : [],
          operations: []
        };
        const metric = promQueryModeller.renderQuery(visualQueryQuery);
        return `label_values(${metric},${QueryVariable.label})`;
      } else {
        return `label_values(${QueryVariable.label})`;
      }
    case PromVariableQueryType.MetricNames:
      return `metrics(${QueryVariable.metric})`;
    case PromVariableQueryType.VarQueryResult:
      const varQuery = removeLineBreaks(QueryVariable.varQuery);
      return `query_result(${varQuery})`;
    case PromVariableQueryType.SeriesQuery:
      return (_c = QueryVariable.seriesQuery) != null ? _c : "";
    case PromVariableQueryType.ClassicQuery:
      return (_d = QueryVariable.classicQuery) != null ? _d : "";
  }
  return "";
}
function removeLineBreaks(input) {
  return input ? input.replace(/[\r\n]+/gm, "") : "";
}

export { PrometheusLabelNamesRegex, PrometheusLabelNamesRegexWithMatch, PrometheusLabelValuesRegex, PrometheusMetricNamesRegex, PrometheusQueryResultRegex, migrateVariableEditorBackToVariableSupport, migrateVariableQueryToEditor };
//# sourceMappingURL=variableMigration.mjs.map
