"use strict";
let singleton;
function setPluginLinksHook(hook) {
  if (singleton && process.env.NODE_ENV !== "test") {
    throw new Error("setPluginLinksHook() function should only be called once, when Grafana is starting.");
  }
  singleton = hook;
}
function usePluginLinks(options) {
  if (!singleton) {
    throw new Error("setPluginLinksHook(options) can only be used after the Grafana instance has started.");
  }
  return singleton(options);
}

export { setPluginLinksHook, usePluginLinks };
//# sourceMappingURL=usePluginLinks.mjs.map
